//
// C++ Interface: k9menu
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9MENU_H
#define K9MENU_H

#include "k9common.h"
#include "k9config.h"
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqimage.h>
#include <tqfont.h>
#include <tqdom.h>
#include <tqcanvas.h>
/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9MenuButton;
class k9Menu : public TQObject {
    TQ_OBJECT
  
public slots:
    void setStartScript(const TQString &);
    void setStartScript2(const TQString &);
    void setEndScript(const TQString& _value);

public:
    enum eFormat {
        PAL=1,NTSC=2
    };
    k9Menu(TQObject *parent = 0, const char *name = 0);
    ~k9Menu();
    k9MenuButton *addButton();
    void createMenus(TQDomElement *_rootNode);
    void setWorkDir(const TQString& _value);
    TQString getWorkDir() const;
    void setFormat(const eFormat& _value);
    void setMenuFileName(const TQString& _value);
    TQString getMenuFileName() const;

    void setCanvas(TQCanvas* _value);
    TQCanvas* getCanvas() const;

    TQString getStartScript() const;
    TQString getEndScript() const;
    TQString getStartScript2() const;
private:
    TQPtrList <k9MenuButton> m_buttons;
    TQString m_workDir;
    TQString m_menuFileName;
    eFormat m_format;
    TQCanvas *m_canvas;
    TQString m_startScript;
    TQString m_startScript2;
    TQString m_endScript;
    k9Config *m_config;
    void convertJpegToMpeg(const TQString &_imageJpg,const TQString &_imageMpg) ;
    void createAudio(const TQString & _audioFile);
    void multiplex(const TQString &_audio, const TQString &_video, const TQString _result);
    void spumux(const TQString &_hiFileName,const TQString &_mpgFileName);
    void appendMenu(TQDomElement *_rootNode);
};

#endif
