/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef BASKETFACTORY_H
#define BASKETFACTORY_H

class TQString;

class Basket;

/** Methods to create various baskets (mkdir, init the properties and load it).
  * @author Sbastien Laot
  */
namespace BasketFactory
{
	/** You should use this method to create a new basket: */
	void newBasket(const TQString &icon,
	               const TQString &name,
	               const TQString &backgroundImage,
	               const TQColor  &backgroundColor,
	               const TQColor  &textColor,
	               const TQString &templateName,
	               Basket *parent);
	/** Internal tool methods to process the method above: */
	TQString newFolderName();
	TQString unpackTemplate(const TQString &templateName);
}

#endif // BASKETFACTORY_H
