/*
 * notify.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the declaration of the KBiffNotify
 * widget.
 *
 * $Id$
 */
#ifndef KBIFFNOTIFY_H 
#define KBIFFNOTIFY_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <tqdialog.h>
#include <tqstring.h>

class TQLabel;

class KBiffNotify : public TQDialog
{
	TQ_OBJECT
public:
	KBiffNotify(TQWidget *parent, const int num_new, const TQString& mailbx);
	virtual ~KBiffNotify();

	const TQString getMailbox() { return mailbox; }
	int newMessages() { return messages; }

	void setNew(const int num_new);

signals:
    void signalLaunchMailClient();

protected slots:
	void slotLaunchMailClient();

protected:
	TQString mailbox;
	TQLabel* msgLabel;
	int     messages;
};

#endif // KBIFFNOTIFY_H
