/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef DBIMPORTDIALOG_H
#define DBIMPORTDIALOG_H

#include <kdialogbase.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQButtonGroup;
class TQRadioButton;
class TQWidgetStack;
class TQWidget;
class TQLineEdit;
class TQLabel;
class TQPushButton;

class KURLRequester;
class KIntNumInput;

/**
@author Jason Kivlighn
*/

class DBImportDialog: public KDialogBase
{
	TQ_OBJECT
public:
	DBImportDialog( TQWidget *parent = 0, const char *name = 0 );

	TQString dbType() const;
	void serverParams( TQString &host, TQString &user, TQString &pass, int &port, TQString &table ) const;
	TQString dbFile() const;

private:
	// Widgets
	TQButtonGroup* dbButtonGroup;
	TQRadioButton* liteRadioButton;
	TQRadioButton* mysqlRadioButton;
	TQRadioButton* psqlRadioButton;
	TQWidgetStack* paramStack;
	TQWidget* serverPage;
	TQLineEdit* nameEdit;
	TQLabel* passwordLabel;
	TQLineEdit* hostEdit;
	TQLineEdit* passwordEdit;
	TQLineEdit* userEdit;
	TQLabel* userLabel;
	TQLabel* hostLabel;
	TQLabel* nameLabel;
	TQLabel* portLabel;
	KIntNumInput *portEdit;
	TQWidget* sqlitePage;
	KURLRequester* sqliteDBRequester;

	TQVBoxLayout* dbButtonGroupLayout;
	TQVBoxLayout* serverPageLayout;
	TQGridLayout* layout5;
	TQVBoxLayout* serverPageLayout_2;

protected slots:
	void languageChange();
	void switchDBPage( int id );

};

#endif
