/***************************************************************************
*   Copyright (C) 2003-2005 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RECIPEINPUTDIALOG_H
#define RECIPEINPUTDIALOG_H

#include <kdialog.h>
#include <ktextedit.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <tdelistview.h>
#include <knuminput.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <kled.h>

#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqmap.h>
#include <tqobject.h>
#include <tqtabwidget.h>
#include <tqtoolbutton.h>
#include <tqvbox.h>

#include "datablocks/elementlist.h"

class TQTabWidget;
class TQTimeEdit;
class TQDragEvent;
class TQButtonGroup;
class TQWidgetStack;
class TQTextEdit;

class KreTextEdit;
class KWidgetListbox;
class KDialogBase;

class ImageDropLabel;
class Recipe;
class ElementList;
class RecipeDB;
class FractionInput;
class Ingredient;
class Rating;
class RatingDisplayWidget;
class IngredientInputWidget;
class ClickableLed;

/**
@author Unai Garro
*/
class RecipeInputDialog: public TQVBox
{
	TQ_OBJECT

public:

	RecipeInputDialog( TQWidget* parent, RecipeDB* db );
	void loadRecipe( int recipeID );
	~RecipeInputDialog();
	void newRecipe( void );
	bool everythingSaved();
	void reload( void );
	int loadedRecipeID() const;

private:

	// Internal Data
	Recipe *loadedRecipe; //Loaded Recipe
	RecipeDB *database;
	bool changedSignalEnabled;
	bool unsavedChanges;

	// Widgets
	TQTabWidget* tabWidget;
	TQGroupBox* recipeTab;
	TQGroupBox* instructionsTab;

	//Recipe Photo
	ImageDropLabel *photoLabel;
	TQPixmap sourcePhoto;
	TQPushButton *changePhotoButton;

	//Recipe Body
	KreTextEdit* instructionsEdit;
	TQLabel* titleLabel;
	KLineEdit* titleEdit;

	//Additional recipe data
	TQLabel* yieldLabel;
	FractionInput* yieldNumInput;
	KLineEdit* yieldTypeEdit;
	TQTimeEdit *prepTimeEdit;
	TQLabel* authorLabel;
	KLineEdit* authorShow;
	TQPushButton* addAuthorButton;
	TQLabel* categoryLabel;
	KLineEdit* categoryShow;
	TQPushButton* addCategoryButton;

	//Ingredient inputs
	TDEListView* ingredientList;
	TQGroupBox *ingredientGBox;
	IngredientInputWidget *ingInput;
	ClickableLed *propertyStatusLed;
	TQLabel *propertyStatusLabel;
	TQPushButton *propertyStatusButton;
	TQTextEdit *statusTextView;
	KDialogBase *propertyStatusDialog;

	// Buttons to move ingredients up & down...
	KPushButton* upButton;
	KPushButton* downButton;
	KPushButton* removeButton;
	KPushButton* addButton;
	KPushButton* ingParserButton;

	//Function buttons
	TQGroupBox* functionsBox;
	TQToolButton* saveButton;
	TQToolButton* closeButton;
	TQToolButton* showButton;
	TQToolButton* resizeButton;

	TQToolButton* spellCheckButton;

	KWidgetListbox *ratingListDisplayWidget;

	TQMap<int,TQString> propertyStatusMapRed;
	TQMap<int,TQString> propertyStatusMapYellow;

	// Internal functions
	int createNewYieldIfNecessary( const TQString &yield );
	void saveRecipe( void );
	void showCategories( void );
	void showAuthors( void );
	int ingItemIndex( TQListView *listview, const TQListViewItem *item ) const;
	void addRating( const Rating &rating, RatingDisplayWidget *item );
	TQString statusMessage() const;
	TQString conversionPath( const TQString &ingUnit, const TQString &toUnit, const TQString &fromUnit, const TQString &propUnit ) const;

	// Signals & Slots

private slots:
	void changePhoto( void );
	void clearPhoto( void );
	void moveIngredientUp( void );
	void moveIngredientDown( void );
	void removeIngredient( void );
	void syncListView( TQListViewItem* it, const TQString &new_text, int col );
	void recipeChanged( void );
	void recipeChanged( const TQString &t );
	void enableChangedSignal( bool en = true );
	void addCategory( void );
	void addAuthor( void );
	void enableSaveButton( bool enabled );
	void closeOptions( void );
	void showRecipe( void );
	void prepTitleChanged( const TQString &title );
	void recipeRemoved( int id );
	void slotIngredientParser();
	void slotAddRating();
	void slotEditRating();
	void slotRemoveRating();
	void addIngredient( const Ingredient &ing, bool noHeader = false );
	void addIngredientHeader( const Element &header );
	void updatePropertyStatus();
	void updatePropertyStatus( const Ingredient &ing, bool updateIndicator );
	void showStatusIndicator();

public slots:
	bool save ( void ); // Activated when krecipes.cpp sends signal save()
	void spellCheck( void );
	void resizeRecipe( void );

signals:
	void changed( void );
	void closeRecipe( void );
	void createButton( TQWidget* w, const TQString &title );
	void enableSaveOption( bool en = true );
	void showRecipe( int recipeID ); //Indicates krecipesview to show it
	void titleChanged( const TQString &title );


};

class ClickableLed : public KLed
{
TQ_OBJECT

public:
	ClickableLed( TQWidget *parent );

protected:
	virtual void mouseReleaseEvent( TQMouseEvent* );

signals:
	void clicked();
};

class ImageDropLabel : public TQLabel
{
	TQ_OBJECT

public:
	ImageDropLabel( TQWidget *parent, TQPixmap &_sourcePhoto );

signals:
	void changed();

protected:
	void dragEnterEvent( TQDragEnterEvent* event );
	void dropEvent( TQDropEvent* event );

private:
	TQPixmap &sourcePhoto;
};

#endif
