/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_IMPORT_FILELISTINGIMPORTER_H
#define TELLICO_IMPORT_FILELISTINGIMPORTER_H

#include "importer.h"
#include "../datavectors.h"

#include <tdeio/global.h>
#include <tdefileitem.h>

#include <tqguardedptr.h>

class TQCheckBox;
namespace TDEIO {
  class Job;
}

namespace Tellico {
  namespace Import {

/**
 * @author Robby Stephenson
 */
class FileListingImporter : public Importer {
TQ_OBJECT
  

public:
  FileListingImporter(const KURL& url);

  /**
   * @return A pointer to a @ref Data::Collection, or 0 if none can be created.
   */
  virtual Data::CollPtr collection();
  /**
   */
  virtual TQWidget* widget(TQWidget*, const char*);
  virtual bool canImport(int type) const;

public slots:
  void slotCancel();

private slots:
  void slotEntries(TDEIO::Job* job, const TDEIO::UDSEntryList& list);

private:
  TQString volumeName() const;

  Data::CollPtr m_coll;
  TQWidget* m_widget;
  TQCheckBox* m_recursive;
  TQCheckBox* m_filePreview;
  TQGuardedPtr<TDEIO::Job> m_job;
  KFileItemList m_files;
  TQPixmap m_pixmap;
  bool m_cancelled : 1;
};

  } // end namespace
} // end namespace
#endif
