
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scaledialog.h"

#include <cstdlib>
#include <klineedit.h>
#include <tdelocale.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqvalidator.h>

ScaleDialog::ScaleDialog(int defaultScale, const TQString &title,
        TQWidget* parent) :
        KDialogBase(parent, "scale dialog", true, title, Ok|Cancel, Ok),
        scale(defaultScale) {
    TQHBox* page = makeHBoxMainWidget();

    new TQLabel(i18n("Scale in KBit/s:"), page);

    TQString scaleStr;
    scaleStr.setNum(defaultScale);
    KLineEdit* scaleBox = new KLineEdit(scaleStr, page);

    TQIntValidator* val = new TQIntValidator(this);
    val->setBottom(1);
    scaleBox->setValidator(val);

    connect(scaleBox, TQ_SIGNAL(textChanged(const TQString&)),
        this, TQ_SLOT(updateScale(const TQString&)));
}

int ScaleDialog::getScale() const {
    return scale;
}

void ScaleDialog::updateScale(const TQString& text) {
    scale = text.toInt();
}

#include "scaledialog.moc"
