/***************************************************************************
 *   Copyright (C) 2006 by Marco Martin   *
 *   notmart@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TASTYTOOLTIP_H
#define TASTYTOOLTIP_H

#include <tqwidget.h>
#include <tqlayout.h>

#include "tastytooltipwidget.h"

/**
	@author Marco Martin <notmart@gmail.com>
*/
class TastyToolTip : public TQWidget
{
public:
  TastyToolTip( TQWidget * parent=0,const char * name=0, WFlags fl=WType_TopLevel);

    ~TastyToolTip();

  void showTip(const TQPoint & point);
  void hideTip( );
  void loadIcon( TQString iconName );
  void notify(const TQPoint & point );
  void setMessage( TQString message );
  void setTitle( TQString title );

protected:
  virtual void mousePressEvent( TQMouseEvent * e ){e=e;hide();}

private:

  TQString iconName;
  TastyToolTipWidget * toolTipWidget;
  TQVBoxLayout *tastyToolTipLayout;

public slots:
  virtual void show();

};

#endif
