# Copyright 1999-2024 Gentoo Authors
# Copyright 2020-2024 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"
TRINITY_MODULE_NAME="tdepim"
TRINITY_MODULE_TYPE="core"
TRINITY_SUBMODULE="wizards"

inherit trinity-meta-2

DESCRIPTION="TDEPIM wizards"

if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi

DEPEND="~trinity-base/certmanager-${PV}
	~trinity-base/knotes-${PV}
	~trinity-base/libkcal-${PV}
	~trinity-base/libkpimidentities-${PV}
	~trinity-base/libtdenetwork-${PV}
	~trinity-base/tdepim-tderesources-${PV}"
RDEPEND="${DEPEND}"

TSM_EXTRACT_ALSO="libtdepim/ tderesources/ kmail/ libkpimidentities/ knotes/ libkcal/ \
	libemailfunctions/"

src_configure() {
	local mycmakeargs=(
		-DWITH_EGROUPWARE=ON
		-DWITH_KOLAB=ON
		-DWITH_SLOX=ON
		-DWITH_GROUPWISE=ON
		-DWITH_NEWEXCHANGE=ON
		-DWITH_SCALIX=ON
	)
	trinity-meta-2_src_configure
}
