// This defines the interface to the TQextScintillaCommand class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLACOMMAND_H
#define TQEXTSCINTILLACOMMAND_H


#include <tqstring.h>

#include <tqextscintillaglobal.h>


class TQextScintilla;


//! \brief The TQextScintillaCommand class represents an internal editor command
//! that may have one or two keys bound to it.
//!
//! Methods are provided to change the keys bound to the command and to remove
//! a key binding.  Each command has a user friendly description of the command
//! for use in key mapping dialogs.
class TQEXTSCINTILLA_EXPORT TQextScintillaCommand
{
public:
	//! Binds the key \a key to the command.  If \a key is 0 then the key
	//! binding is removed.  If \a key is invalid then the key binding is
	//! unchanged.  Valid keys are any visible or control character or any
	//! of \c Key_Down, \c Key_Up, \c Key_Left, \c Key_Right, \c Key_Home,
	//! \c Key_End, \c Key_Prior, \c Key_Next, \c Key_Delete,
	//! \c Key_Insert, \c Key_Escape, \c Key_Backspace, \c Key_Tab and
	//! \c Key_Return.  Keys may be modified with any combination of
	//! \c SHIFT, \c CTRL and \c ALT.
	//!
	//! \sa key(), setAlternateKey(), validKey()
	void setKey(int key);

	//! Binds the alternate key \a altkey to the command.  If \a key is 0
	//! then the alternate key binding is removed.
	//!
	//! \sa alternateKey(), setKey(), validKey()
	void setAlternateKey(int altkey);

	//! The key that is currently bound to the command is returned.
	//!
	//! \sa setKey(), alternateKey()
	int key() const {return qkey;}

	//! The alternate key that is currently bound to the command is
	//! returned.
	//!
	//! \sa setAlternateKey(), key()
	int alternateKey() const {return qaltkey;}

	//! If the key \a key is valid then true is returned.
	static bool validKey(int key);

	//! The user friendly description of the command is returned.
	TQString description() const;

private:
	friend class TQextScintillaCommandSet;

	TQextScintillaCommand(TQextScintilla *qs,int msg,int key,int altkey,
			     const char *desc);

	int msgId() const {return msgCmd;}
	void bindKey(int key,int &qk,int &scik);

	TQextScintilla *qsCmd;
	int msgCmd;
	int qkey, scikey, qaltkey, scialtkey;
	const char *descCmd;

#if defined(TQ_DISABLE_COPY)
	TQextScintillaCommand(const TQextScintillaCommand &);
	TQextScintillaCommand &operator=(const TQextScintillaCommand &);
#endif
};

#endif
