bool Module::process(const TQCString &fun, const TQByteArray &data,
    TQCString &replyType, TQByteArray &replyData)
    {
    if( fun == "initializeIntegration(TQString)" )
        {
        pre_initializeIntegration( data, replyData );
        replyType = "bool";
        return true;
        }
    if( fun == "getOpenFileNames(TQString,TQString,long,TQCString,TQString,TQString,bool,TQCString,TQCString)" )
        {
        pre_getOpenFileNames( data );
        return true;
        }
    if( fun == "getSaveFileName(TQString,TQString,TQString,long,TQCString,TQString,TQString,TQCString,TQCString)" )
        {
        pre_getSaveFileName( data );
        return true;
        }
    if( fun == "getExistingDirectory(TQString,long,TQCString,TQString,TQCString,TQCString)" )
        {
        pre_getExistingDirectory( data );
        return true;
        }
    if( fun == "getColor(TQColor,long,TQCString,TQCString,TQCString)" )
        {
        pre_getColor( data );
        return true;
        }
    if( fun == "getFont(bool,TQFont,long,TQCString,TQCString,TQCString)" )
        {
        pre_getFont( data );
        return true;
        }
    if( fun == "messageBox1(int,long,TQString,TQString,int,int,int,TQCString,TQCString)" )
        {
        pre_messageBox1( data );
        return true;
        }
    if( fun == "messageBox2(int,long,TQString,TQString,TQString,TQString,TQString,int,int,TQCString,TQCString)" )
        {
        pre_messageBox2( data );
        return true;
        }
    return KDEDModule::process( fun, data, replyType, replyData );
    }

QCStringList Module::functions()
    {
    QCStringList funcs = KDEDModule::functions();
    funcs << "initializeIntegration(TQString)";
    funcs << "getOpenFileNames(TQString,TQString,long,TQCString,TQString,TQString,bool,TQCString,TQCString)";
    funcs << "getSaveFileName(TQString,TQString,TQString,long,TQCString,TQString,TQString,TQCString,TQCString)";
    funcs << "getExistingDirectory(TQString,long,TQCString,TQString,TQCString,TQCString)";
    funcs << "getColor(TQColor,long,TQCString,TQCString,TQCString)";
    funcs << "getFont(bool,TQFont,long,TQCString,TQCString,TQCString)";
    funcs << "messageBox1(int,long,TQString,TQString,int,int,int,TQCString,TQCString)";
    funcs << "messageBox2(int,long,TQString,TQString,TQString,TQString,TQString,int,int,TQCString,TQCString)";
    return funcs;
    }

QCStringList Module::interfaces()
    {
    QCStringList ifaces = KDEDModule::interfaces();
    ifaces << "TDEIntegration";
    return ifaces;
    }

void Module::pre_initializeIntegration( const TQByteArray& data, TQByteArray& replyData )
    {
    TQString hostname;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> hostname;
    post_initializeIntegration( initializeIntegration( hostname ), replyData );
    }

void Module::pre_getOpenFileNames( const TQByteArray& data )
    {
    JobData job;
    job.transaction = kapp->dcopClient()->beginTransaction();
    job.type = JobData::GetOpenFileNames;
    TQString filter;
    TQString workingDirectory;
    long parent;
    TQCString name;
    TQString caption;
    TQString selectedFilter;
    bool multiple;
    TQCString wmclass1;
    TQCString wmclass2;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> filter >> workingDirectory >> parent >> name >> caption >> selectedFilter >> multiple >> wmclass1 >> wmclass2;
    void* handle = getOpenFileNames( filter, workingDirectory, parent, name, caption, selectedFilter, multiple, wmclass1, wmclass2 );
    jobs[ handle ] = job;
    }

void Module::pre_getSaveFileName( const TQByteArray& data )
    {
    JobData job;
    job.transaction = kapp->dcopClient()->beginTransaction();
    job.type = JobData::GetSaveFileName;
    TQString initialSelection;
    TQString filter;
    TQString workingDirectory;
    long parent;
    TQCString name;
    TQString caption;
    TQString selectedFilter;
    TQCString wmclass1;
    TQCString wmclass2;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> initialSelection >> filter >> workingDirectory >> parent >> name >> caption >> selectedFilter >> wmclass1 >> wmclass2;
    void* handle = getSaveFileName( initialSelection, filter, workingDirectory, parent, name, caption, selectedFilter, wmclass1, wmclass2 );
    jobs[ handle ] = job;
    }

void Module::pre_getExistingDirectory( const TQByteArray& data )
    {
    JobData job;
    job.transaction = kapp->dcopClient()->beginTransaction();
    job.type = JobData::GetExistingDirectory;
    TQString initialDirectory;
    long parent;
    TQCString name;
    TQString caption;
    TQCString wmclass1;
    TQCString wmclass2;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> initialDirectory >> parent >> name >> caption >> wmclass1 >> wmclass2;
    void* handle = getExistingDirectory( initialDirectory, parent, name, caption, wmclass1, wmclass2 );
    jobs[ handle ] = job;
    }

void Module::pre_getColor( const TQByteArray& data )
    {
    JobData job;
    job.transaction = kapp->dcopClient()->beginTransaction();
    job.type = JobData::GetColor;
    TQColor color;
    long parent;
    TQCString name;
    TQCString wmclass1;
    TQCString wmclass2;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> color >> parent >> name >> wmclass1 >> wmclass2;
    void* handle = getColor( color, parent, name, wmclass1, wmclass2 );
    jobs[ handle ] = job;
    }

void Module::pre_getFont( const TQByteArray& data )
    {
    JobData job;
    job.transaction = kapp->dcopClient()->beginTransaction();
    job.type = JobData::GetFont;
    bool ok;
    TQFont def;
    long parent;
    TQCString name;
    TQCString wmclass1;
    TQCString wmclass2;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> ok >> def >> parent >> name >> wmclass1 >> wmclass2;
    void* handle = getFont( ok, def, parent, name, wmclass1, wmclass2 );
    jobs[ handle ] = job;
    }

void Module::pre_messageBox1( const TQByteArray& data )
    {
    JobData job;
    job.transaction = kapp->dcopClient()->beginTransaction();
    job.type = JobData::MessageBox1;
    int type;
    long parent;
    TQString caption;
    TQString text;
    int button0;
    int button1;
    int button2;
    TQCString wmclass1;
    TQCString wmclass2;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> type >> parent >> caption >> text >> button0 >> button1 >> button2 >> wmclass1 >> wmclass2;
    void* handle = messageBox1( type, parent, caption, text, button0, button1, button2, wmclass1, wmclass2 );
    jobs[ handle ] = job;
    }

void Module::pre_messageBox2( const TQByteArray& data )
    {
    JobData job;
    job.transaction = kapp->dcopClient()->beginTransaction();
    job.type = JobData::MessageBox2;
    int type;
    long parent;
    TQString caption;
    TQString text;
    TQString button0Text;
    TQString button1Text;
    TQString button2Text;
    int defaultButton;
    int escapeButton;
    TQCString wmclass1;
    TQCString wmclass2;
    TQDataStream datastream( data, IO_ReadOnly );
    datastream >> type >> parent >> caption >> text >> button0Text >> button1Text >> button2Text >> defaultButton >> escapeButton >> wmclass1 >> wmclass2;
    void* handle = messageBox2( type, parent, caption, text, button0Text, button1Text, button2Text, defaultButton, escapeButton, wmclass1, wmclass2 );
    jobs[ handle ] = job;
    }

void Module::post_initializeIntegration( bool ret, TQByteArray& replyData )
    {
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    }

void Module::post_getOpenFileNames( void* handle, TQStringList ret, TQString workingDirectory, TQString selectedFilter )
    {
    assert( jobs.contains( handle ));
    JobData job = jobs[ handle ];
    jobs.remove( handle );
    TQByteArray replyData;
    TQCString replyType = "tqttde";
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    replystream << workingDirectory << selectedFilter;
    kapp->dcopClient()->endTransaction( job.transaction, replyType, replyData );
    }

void Module::post_getSaveFileName( void* handle, TQString ret, TQString workingDirectory, TQString selectedFilter )
    {
    assert( jobs.contains( handle ));
    JobData job = jobs[ handle ];
    jobs.remove( handle );
    TQByteArray replyData;
    TQCString replyType = "tqttde";
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    replystream << workingDirectory << selectedFilter;
    kapp->dcopClient()->endTransaction( job.transaction, replyType, replyData );
    }

void Module::post_getExistingDirectory( void* handle, TQString ret )
    {
    assert( jobs.contains( handle ));
    JobData job = jobs[ handle ];
    jobs.remove( handle );
    TQByteArray replyData;
    TQCString replyType = "tqttde";
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    kapp->dcopClient()->endTransaction( job.transaction, replyType, replyData );
    }

void Module::post_getColor( void* handle, TQColor ret )
    {
    assert( jobs.contains( handle ));
    JobData job = jobs[ handle ];
    jobs.remove( handle );
    TQByteArray replyData;
    TQCString replyType = "tqttde";
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    kapp->dcopClient()->endTransaction( job.transaction, replyType, replyData );
    }

void Module::post_getFont( void* handle, TQFont ret, bool ok )
    {
    assert( jobs.contains( handle ));
    JobData job = jobs[ handle ];
    jobs.remove( handle );
    TQByteArray replyData;
    TQCString replyType = "tqttde";
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    replystream << ok;
    kapp->dcopClient()->endTransaction( job.transaction, replyType, replyData );
    }

void Module::post_messageBox1( void* handle, int ret )
    {
    assert( jobs.contains( handle ));
    JobData job = jobs[ handle ];
    jobs.remove( handle );
    TQByteArray replyData;
    TQCString replyType = "tqttde";
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    kapp->dcopClient()->endTransaction( job.transaction, replyType, replyData );
    }

void Module::post_messageBox2( void* handle, int ret )
    {
    assert( jobs.contains( handle ));
    JobData job = jobs[ handle ];
    jobs.remove( handle );
    TQByteArray replyData;
    TQCString replyType = "tqttde";
    TQDataStream replystream( replyData, IO_WriteOnly );
    replystream << ret;
    kapp->dcopClient()->endTransaction( job.transaction, replyType, replyData );
    }

