#ifndef KOLF_STATEDB_H
#define KOLF_STATEDB_H

#include <tqmap.h>
#include <tqstring.h>
#include <tqpoint.h>

// items can save their per-game states here
// most don't have to do anything
class StateDB
{
public:
	void setPoint(const TQPoint &point) { points[curName] = point; }
	TQPoint point() { return points[curName]; }
	void setName(const TQString &name) { curName = name; }
	void clear() { points.clear(); }

private:
	TQMap<TQString, TQPoint> points;
	TQString curName;
};

#endif
