/* This file is part of the KDE project
   Copyright (C) 2006 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#ifndef KEXILOOKUPCOLUMNPAGE_H
#define KEXILOOKUPCOLUMNPAGE_H

#include <tqwidget.h>
#include <kexidb/field.h>
#include <kexidb/utils.h>
#include <koproperty/set.h>

class KCommand;
class KexiObjectInfoLabel;
class KexiDataSourceComboBox;
class KexiFieldComboBox;
class KexiFieldListView;
class KexiProject;
class KexiSmallToolButton;
class TQToolButton;
class TQLabel;
class TQFrame;

//! @short A page within table designer's property pane, providing lookup column editor.
/*! It's data model is basically KexiDB::LookupFieldSchema class, but the page does 
 not create it directly but instead updates a property set that defines 
 the field currently selected in the designer. 
 
 @todo not all features of KexiDB::LookupFieldSchema class are displayed on this page yet
 */
class KexiLookupColumnPage : public TQWidget
{
	TQ_OBJECT
  

	public:
		KexiLookupColumnPage(TQWidget *parent);
		virtual ~KexiLookupColumnPage();

	public slots:
		void setProject(KexiProject *prj);
		void clearRowSourceSelection(bool alsoClearComboBox = true);
		void clearBoundColumnSelection();
		void clearVisibleColumnSelection();

		//! Receives a pointer to a new property \a set (from KexiFormView::managerPropertyChanged())
		void assignPropertySet(KoProperty::Set* propertySet);

	signals:
		//! Signal emitted when helper button 'Go to selected row sourcesource' is clicked.
		void jumpToObjectRequested(const TQCString& mime, const TQCString& name);

//		/*! Signal emitted when current bound column has been changed. */
//		void boundColumnChanged(const TQString& string, const TQString& caption,
	//		KexiDB::Field::Type type);

	protected slots:
		void slotRowSourceTextChanged(const TQString & string);
		void slotRowSourceChanged();
		void slotGotoSelectedRowSource();
		void slotBoundColumnSelected();
		void slotVisibleColumnSelected();

	protected:
		void updateBoundColumnWidgetsAvailability();

		//! Used instead of m_propertySet->changeProperty() to honor m_propertySetEnabled
		void changeProperty(const TQCString &property, const TQVariant &value);

	private:
		class Private;
		Private* d;
};

#endif
