/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqimage.h>

#ifdef USE_QT4

QRgb *QImage::ptrColorTable() const {
	return colorTable().data();
}

TQImageIO::TQImageIO() {
	m_imageReader = new QImageReader();
	m_imageWriter = new QImageWriter();
}

TQImageIO::TQImageIO( QIODevice	 *ioDevice, const char *format ) {
	m_imageReader = new QImageReader(ioDevice, format);
	m_imageWriter = new QImageWriter(ioDevice, format);
}

TQImageIO::TQImageIO( const QString &fileName, const char* format ) {
	m_imageReader = new QImageReader(fileName, format);
	m_imageWriter = new QImageWriter(fileName, format);
}
TQImageIO::~TQImageIO() {
	delete m_imageReader;
	delete m_imageWriter;
}

bool TQImageIO::read() {
	m_currentImage = m_imageReader->read();
	if (m_currentImage.isNull() == true)
		return false;
	return true;
}

bool TQImageIO::write() {
	return m_imageWriter->write(m_currentImage);
}

const QImage &TQImageIO::image() const {
	return m_currentImage;
}

void TQImageIO::setImage( const QImage & image ) {
	m_currentImage = image;
}

#endif // USE_QT4
