/*  This file is part of the TDE project
    Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

#include "polkit-agent-tde.h"

int main(int argc, char *argv[])
{
  TDEAboutData aboutData("polkit-agent-tde", I18N_NOOP("Polkit-Agent-TDE"), "0.99.1",
          I18N_NOOP("A Polkit authentication agent for TDE"), TDEAboutData::License_GPL,
          I18N_NOOP("(c) 2009 Red Hat, Inc."));
  aboutData.addAuthor(I18N_NOOP("Jaroslav Reznik"), I18N_NOOP("Maintainer"), "jreznik@redhat.com");
  aboutData.setProductName("policykit-agent-tde");

  TDECmdLineArgs::init(argc, argv, &aboutData);

  if (!PolkitAgentTDE::start())
  {
    tqWarning("PolkitAgentTDE is already running!\n");
    return 0;
  }

  PolkitAgentTDE agent;
  agent.disableSessionManagement();
  return agent.exec();
}
