/*
    Kopete Yahoo Protocol
    Handles conferences

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef CONFERENCETASK_H
#define CONFERENCETASK_H

#include "task.h"

class YMSGTransfer;

/**
@author André Duffeck
*/
class ConferenceTask : public Task
{
	TQ_OBJECT
  
public:
	ConferenceTask(Task *parent);
	~ConferenceTask();

	bool take(Transfer *transfer);
	bool forMe( const Transfer* transfer ) const;

	void joinConference( const TQString &room, const TQStringList &members );
	void declineConference( const TQString &room, const TQStringList &members, const TQString &msg );
	void leaveConference( const TQString &room, const TQStringList &members );
	void sendMessage( const TQString &room, const TQStringList &members, const TQString &msg );
	void inviteConference( const TQString &room, const TQStringList &members, const TQString &msg );
	void addInvite( const TQString &room, const TQStringList &who, const TQStringList &members, const TQString &msg );
signals:
	void gotInvite( const TQString &who, const TQString &room, const TQString &msg, const TQStringList &members);
	void gotMessage( const TQString &who, const TQString &room, const TQString &msg );
	void userJoined( const TQString &who, const TQString &room );
	void userLeft( const TQString &who, const TQString &room );
	void userDeclined( const TQString &who, const TQString &room, const TQString &msg );
private:
	void parseInvitation( YMSGTransfer *transfer );
	void parseMessage( YMSGTransfer *transfer );
	void parseUserJoined( YMSGTransfer *transfer );
	void parseUserLeft( YMSGTransfer *transfer );
	void parseUserDeclined( YMSGTransfer *transfer );
};

#endif
