/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef UTILCSORTLISTVIEWITEM_H
#define UTILCSORTLISTVIEWITEM_H


#include <tqmap.h>

#include <tdelistview.h>

namespace util {

/**
 * A implementation of a TQListViewItem to allow special sort orders for it's columns.
 * @author The BibleTime team <info@bibletime.info>
*/
class CSortListViewItem : public TDEListViewItem {
public:
	enum Type {
		Number, String/*, BibleKey*/
	};
	
    CSortListViewItem( TQListViewItem* parent );
	
	CSortListViewItem( TQListView * parent, TQListViewItem * after );
	
	CSortListViewItem( TQListViewItem * parent, TQListViewItem * after );
	
	CSortListViewItem( TQListView * parent, TQString label1, TQString label2 = TQString(), TQString label3 = TQString(), TQString label4 = TQString(), TQString label5 = TQString(), TQString label6 = TQString(), TQString label7 = TQString(), TQString label8 = TQString() );

	CSortListViewItem( TQListViewItem * parent, TQString label1, TQString label2 = TQString(), TQString label3 = TQString(), TQString label4 = TQString(), TQString label5 = TQString(), TQString label6 = TQString(), TQString label7 = TQString(), TQString label8 = TQString() );

	CSortListViewItem( TQListView * parent, TQListViewItem * after, TQString label1, TQString label2 = TQString(), TQString label3 = TQString(), TQString label4 = TQString(), TQString label5 = TQString(), TQString label6 = TQString(), TQString label7 = TQString(), TQString label8 = TQString() );

	CSortListViewItem( TQListViewItem * parent, TQListViewItem * after, TQString label1, TQString label2 = TQString(), TQString label3 = TQString(), TQString label4 = TQString(), TQString label5 = TQString(), TQString label6 = TQString(), TQString label7 = TQString(), TQString label8 = TQString() );

	virtual ~CSortListViewItem();
	
	virtual int compare( TQListViewItem* i, int col, bool ascending ) const;

	void setColumnSorting(int column, Type type);

private:
	TQMap<int, Type> columnSorting;
};

}

#endif
