/***************************************************************************
                          fileoperation.h  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEOPERATION_H
#define FILEOPERATION_H

#include <tqobject.h>
#include <tdeio/jobclasses.h>
#include <kurl.h>

class TQString;
class FileOperation: public TQObject {
    TQ_OBJECT
  
    public:
        FileOperation();
        ~FileOperation();

        bool start( const KURL & src, const KURL & dest, int mode, bool overwrite );
        bool fcopy( const TQString & src, const TQString & dest );

        inline const TQString & error() const;
        static TQString getName( const TQString & file );

    private slots:
        void slotResult( TDEIO::Job * job );

    private:
        bool locked;
        bool canceled;
        int result;

        TQString m_error;
};

inline const TQString & FileOperation::error() const
{ 
    return m_error; 
}

#endif
