/***************************************************************************
                          wizard.cpp  -  description
                             -------------------
    begin                : Die Mai 15 15:34:19 CEST 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Own includes
#include "wizard.h"
#include "krenameimpl.h"

// TDE includes
#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemenubar.h>
#include <tdemessagebox.h>
#include <tdestartupinfo.h>

// TQt includes
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqsizepolicy.h>
#include <tqvbox.h>

wizard::wizard( KRenameImpl* impl, TQRect r, TQWidget* parent,  const char* name )
    : KWizard( parent, name )
{
    setIcon( BarIcon( "krename" ) );
    menuBar = new KMenuBar(this);

    krename = impl ? impl : new KRenameImpl( this, menuBar, this->finishButton() );

    connect( krename, TQ_SIGNAL( pageDone( TQWidget*, const TQString & ) ), this, TQ_SLOT( slotAddPage( TQWidget*, const TQString & ) ) );
    connect( krename, TQ_SIGNAL( showPage( int ) ), this, TQ_SLOT( slotShowPage( int ) ) );
    connect( krename, TQ_SIGNAL( enableFinish( bool ) ), this, TQ_SLOT( slotEnableFinish( bool ) ) );

    if( impl )
    {
        krename->changeParent( this, menuBar, this->finishButton(), r );
        krename->setWizardMode( true );
    } else
        krename->setup( true );
    
    // Tell TDEStartupInfo that KRename has been loaded completly
    TDEStartupInfoId id;
    id.initId( kapp->startupId() );
    TDEStartupInfo::sendFinish( id );
    
    // Disable ESC key
    cancelButton()->setAccel( TQKeySequence() );
}

wizard::~wizard()
{
}

void wizard::slotAddPage( TQWidget* page, const TQString & title )
{
    // exclude page 3 from wizard
    if( krename->title( 2 ) == title )
    {
        page->hide();
        return;
    }

    TQString t = title + i18n(" - Step %1 of %2").arg( pageCount()+1 ).arg( 3 );
        
    TQVBox* layout = new TQVBox( this );
   
    new TQLabel( TQString( t ).remove( title.find( "&" ), 1 ), layout );

    TQFrame* hbar1 = new TQFrame( layout, "<hr>", 0 );
    hbar1->setFrameStyle( TQFrame::Sunken + TQFrame::HLine );

    page->reparent( layout, TQPoint( 0, 0 ) );
    addPage( layout, t );
    setHelpEnabled( layout, false );
}

void wizard::slotShowPage( int page )
{
    showPage( this->page( page - 1 ) );
}

void wizard::slotEnableFinish( bool b )
{
    setFinishEnabled( page( pageCount() - 1), b );
}

void wizard::accept()
{
/** do nothing */
}

#include "wizard.moc"
