#!/usr/bin/env qjscmd
// Populates the sidebar listview
function setup_sidebar( special, qt, all )
{
    var qobjects = Factory.constructors().sort();

    for ( var i=0; i < qobjects.length ; i++ ) {
	all.insertItem( qobjects[i] );

	if ( /^Q/.test(qobjects[i]) )
	    qt.insertItem( qobjects[i] );
	else
	    special.insertItem( qobjects[i] );
    }
}

function documentStaticObject( type )
{	
	HelpPage.text ="<h1>" + type + "</h1><HR>";
	try{
	var obj = eval( type );
	HelpPage.text += dump(obj);
	}
	catch (error)
	{
		HelpPage.text += "This object is not supported by this version of KJSEmbed";
	}
}

function documentConstructableObject( type )
{
	HelpPage.text ="<h1>" + type + "</h1><HR>";
	if ( type!= 'TextStream' ) 
	{
		try {
				HelpPage.text += dump(Factory.createObject( type ));
			}
		catch(x) {
			HelpPage.text +='Bindings for the ' + type + ' class.<br /> This class is understood by the interpreter, but cannot be created from scripts.'
		}
	}
}

function populateStaticObjects()
{
	StaticObjectList.clear();
	var statics = [ 'Factory', 'System', 'Global', 'StdDialog',
                'StdAction', 'StdDirs', 'StdIcons', 'Qt' ];
	for ( var idx = 0; idx < statics.length; idx++ )
	{
		StaticObjectList.insertItem(statics[idx]);
	}
}

function populateExceptions()
{
	var expts = [ 'ReferenceError', 'EvalError', 'RangeError', 'TypeError' ];
	for ( var idx = 0; idx < expts.length; idx++ )
	{
		ExceptionTypeList.insertItem(expts[idx]);
	}
}

function populateObjects()
{
	var tps = Factory.types().sort();
	QtObjectList.clear();
	KJSEmbedObjectList.clear();
	KDEObjectList.clear();
	ObjectTypeList.clear();
	
	cons = Factory.constructors().sort();
	cons += 'Part';

	for ( var i=0; i < tps.length; i++ ) {
	     
		if ( /^Q/.test(tps[i]) ) {
 		QtObjectList.insertItem( tps[i] );
		}
		else if ( /^KJSEmbed::/.test(tps[i]) ) {
		if ( tps[i] != 'KJSEmbed::Bindings::JSDCOPInterface' ) {
			KJSEmbedObjectList.insertItem( tps[i] );
		}
		}
		else if ( /^K/.test(tps[i]) ) {
 			KDEObjectList.insertItem( tps[i] );
		}
		else {
 			ObjectTypeList.insertItem( tps[i] );
		}
	}
}
//
// Main
//

// Create the UI
var mw = Factory.loadui("docviewer.ui");
//mw.qt_central_widget.HelpPage.text = dump(mw.qt_central_widget.Navbar.StaticObjects.StaticObjectList);
var HelpPage = mw.qt_central_widget.HelpPage;
var StaticObjectList = mw.qt_central_widget.Navbar.StaticObjects.StaticObjectList;
var ExceptionTypeList = mw.qt_central_widget.Navbar.ExceptionTypes.ExceptionTypeList;
var KDEObjectList = mw.qt_central_widget.Navbar.KDEObjects.KDEObjectList;
var QtObjectList = mw.qt_central_widget.Navbar.QtObjects.QtObjectList;
var KJSEmbedObjectList = mw.qt_central_widget.Navbar.KJSEmbedObjects.KJSEmbedObjectList;
var ObjectTypeList = mw.qt_central_widget.Navbar.ObjectTypes.ObjectTypeList;

populateStaticObjects();
populateExceptions();
populateObjects();

mw.connect( StaticObjectList, 'highlighted(const TQString&)', this, 'documentStaticObject' );
mw.connect( ExceptionTypeList, 'highlighted(const TQString&)', this, 'documentStaticObject' );
mw.connect( KDEObjectList, 'highlighted(const TQString&)', this, 'documentConstructableObject' );
mw.connect( QtObjectList, 'highlighted(const TQString&)', this, 'documentConstructableObject' );
mw.connect( KJSEmbedObjectList, 'highlighted(const TQString&)', this, 'documentConstructableObject' );
mw.connect( ObjectTypeList, 'highlighted(const TQString&)', this, 'documentConstructableObject' );


mw.show();
application.exec();
/*

side = new TQTabWidget( split, 'sidebar' );
view = new TQTabWidget( split, 'mainview' );

// Load the view
js = new TQTextEdit( view, 'js' );
js.setReadOnly( true );

view.addTab( js, '&Javascript' );

view.set_class = function( clazz )
{
   clazz = clazz.replace( '^[^QK]*', '' );

   // JS docs
   var s = '';

   s = s + '<html>';
   s = s + '<body>';
   s = s + '<h1>' + clazz + '</h1>';

   try {
     var obj = eval('new '+clazz+'()'); 
     s = s + dump(obj);
   }
   catch ( err ) {
     s = s + '<font color="red">Error dumping object: ' + err + '</font>';
   }

   s = s + '</body>';
   s = s + '</html>';

   js.text = s;
}

view.setup = function()
{
  // JS docs
  var s = '';
  s = s + '<html>';
  s = s + '<body>';
  s = s + '<h1>Script Reference</h1>';
  s = s + '</body>';
  s = s + '</html>';

   js.text = s;
}

// Setup the sidebar
specialside = new TQListBox( side, 'specialsidebar' );
qtside = new TQListBox( side, 'qtsidebar' );
allside = new TQListBox( side, 'allsidebar' );

side.addTab( specialside, '&Special' );
side.addTab( qtside, '&Qt' );
side.addTab( allside, '&All' );

setup_sidebar( specialside, qtside, allside );

qtside.connect( qtside, 'highlighted(const TQString&)', view, 'set_class' );
specialside.connect( specialside, 'highlighted(const TQString&)', view, 'set_class' );
allside.connect( allside, 'highlighted(const TQString&)', view, 'set_class' );

//
// Show the window
//

side.maximumWidth = 250;
mw.resize( 800, 550 );

mw.show();

//
// Connect together
//
view.setup();

application.exec();
*/
