//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQObject;

/**

 The base class for all jobs.
 For all jobs created in an application, the code looks like
 <pre>
   TDEIO.Job  job = TDEIO.someoperation( some parameters );
   connect( job, TQ_SIGNAL("result( TDEIO.Job  )"),
            this, TQ_SLOT("slotResult( TDEIO.Job  )") );
 </pre>
   (other connects, specific to the job)
 And slotResult is usually at least:
 <pre>
  if ( job.error() )
      job.showErrorDialog( this or null  );
 </pre>
 See {@link JobSignals} for signals emitted by Job
		@short    The base class for all jobs.
		@see Scheduler
		@see Slave

*/
public class Job extends TQObject  {
	protected Job(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Abort this job.
		 This kills all subjobs and deletes the job.
			@param quietly if false, Job will emit signal result
		 and ask tdeio_uiserver to close the progress window.
		 <code>quietly</code> is set to true for subjobs. Whether applications
		 should call with true or false depends on whether they rely
		 on result being emitted or not.
		         		@short    Abort this job.
	*/
	public native void kill(boolean quietly);
	public native void kill();
	/**
		 Returns the error code, if there has been an error.
		 Only call this method from the slot connected to result().
				@return the error code for this job, 0 if no error.
 Error codes are defined in TDEIO.Error.

		@short    Returns the error code, if there has been an error.
	*/
	public native int error();
	/**
		 Returns the progress id for this job.
				@return the progress id for this job, as returned by uiserver

		@short    Returns the progress id for this job.
	*/
	public native int progressId();
	/**
		 Returns the error text if there has been an error.
		 Only call if error is not 0.
		 This is really internal, better use errorString() or errorDialog().
				@return a string to help understand the error, usually the url
 related to the error. Only valid if error() is not 0.

		@short    Returns the error text if there has been an error.
	*/
	public native String errorText();
	/**
		 Converts an error code and a non-i18n error message into an
		 error message in the current language. The low level (non-i18n)
		 error message (usually a url) is put into the translated error
		 message using %1.
			 Example for errid == ERR_CANNOT_OPEN_FOR_READING:
		 <pre>
		   i18n( "Could not read\n%1" ).arg( errortext );
		 </pre>
		 Use this to display the error yourself, but for a dialog box
		 use Job.showErrorDialog. Do not call it if error()
		 is not 0.
				@return the error message and if there is no error, a message
         telling the user that the app is broken, so check with
         error() whether there is an error

		@short    Converts an error code and a non-i18n error message into an  error message in the current language.
	*/
	public native String errorString();
	/**
		 Converts an error code and a non-i18n error message into i18n
		 strings suitable for presentation in a detailed error message box.
			@param reqUrl the request URL that generated this error message
			@param method the method that generated this error message
		 (unimplemented)
				@return the following strings: caption, error + description,
         causes+solutions

		@short    Converts an error code and a non-i18n error message into i18n  strings suitable for presentation in a detailed error message box.
	*/
	public native ArrayList detailedErrorStrings(KURL reqUrl, int method);
	public native ArrayList detailedErrorStrings(KURL reqUrl);
	public native ArrayList detailedErrorStrings();
	/**
		 Display a dialog box to inform the user of the error given by
		 this job.
		 Only call if error is not 0, and only in the slot connected
		 to result.
			@param parent the parent widget for the dialog box, can be 0 for
		        top-level
		         		@short    Display a dialog box to inform the user of the error given by  this job.
	*/
	public native void showErrorDialog(TQWidget parent);
	public native void showErrorDialog();
	/**
		 Enable or disable the automatic error handling. When automatic
		 error handling is enabled and an error occurs, then showErrorDialog()
		 is called with the specified <code>parentWidget</code> (if supplied) , right before
		 the emission of the result signal.
			 The default is false.
			@param enable enable or disable automatic error handling
			@param parentWidget the parent widget, passed to showErrorDialog.
		        Can be 0 for top-level
				@short    Enable or disable the automatic error handling.
		@see #isAutoErrorHandlingEnabled
		@see #showErrorDialog
	*/
	public native void setAutoErrorHandlingEnabled(boolean enable, TQWidget parentWidget);
	public native void setAutoErrorHandlingEnabled(boolean enable);
	/**
		 Returns whether automatic error handling is enabled or disabled.
				@return true if automatic error handling is enabled

		@short    Returns whether automatic error handling is enabled or disabled.
		@see #setAutoErrorHandlingEnabled
	*/
	public native boolean isAutoErrorHandlingEnabled();
	/**
		 Enable or disable the automatic warning handling. When automatic
		 warning handling is enabled and an error occurs, then a message box
		 is displayed with the warning message
			 The default is true.
			 See also isAutoWarningHandlingEnabled , showErrorDialog
			@param enable enable or disable automatic warning handling
				@short    Enable or disable the automatic warning handling.
		@see #isAutoWarningHandlingEnabled
	*/
	public native void setAutoWarningHandlingEnabled(boolean enable);
	/**
		 Returns whether automatic warning handling is enabled or disabled.
		 See also setAutoWarningHandlingEnabled .
				@return true if automatic warning handling is enabled

		@short    Returns whether automatic warning handling is enabled or disabled.
		@see #setAutoWarningHandlingEnabled
	*/
	public native boolean isAutoWarningHandlingEnabled();
	/**
		 Enable or disable the message display from the job.
			 The default is true.
			@param enable enable or disable message display
				@short    Enable or disable the message display from the job.
	*/
	public native void setInteractive(boolean enable);
	/**
		 Returns whether message display is enabled or disabled.
				@return true if message display is enabled

		@short    Returns whether message display is enabled or disabled.
		@see #setInteractive
	*/
	public native boolean isInteractive();
	/**
		 Associate this job with a window given by <code>window.</code>
			@param window the window to associate to
				@short    Associate this job with a window given by <code>window.</code>
		@see #window
	*/
	public native void setWindow(TQWidget window);
	/**
		 Returns the window this job is associated with.
				@return the associated window

		@short    Returns the window this job is associated with.
		@see #setWindow
	*/
	public native TQWidget window();
	/**
		 Set the parent Job.
		 One example use of this is when FileCopyJob calls open_RenameDlg,
		 it must pass the correct progress ID of the parent CopyJob
		 (to hide the progress dialog).
		 You can set the parent job only once. By default a job does not
		 have a parent job.
			@param parentJob the new parent job
				@short    Set the parent Job.
	*/
	public native void setParentJob(Job parentJob);
	/**
		 Returns the parent job, if there is one.
				@return the parent job, or 0 if there is none

		@short    Returns the parent job, if there is one.
		@see #setParentJob
	*/
	public native Job parentJob();
	/**
		 Set meta data to be sent to the slave, replacing existing
		 meta data.
			@param metaData the meta data to set
				@short    Set meta data to be sent to the slave, replacing existing  meta data.
		@see #addMetaData
		@see #mergeMetaData
	*/
	// void setMetaData(const TDEIO::MetaData& arg1); >>>> NOT CONVERTED
	/**
		 Add key/value pair to the meta data that is sent to the slave.
			@param key the key of the meta data
			@param value the value of the meta data
				@short    Add key/value pair to the meta data that is sent to the slave.
		@see #setMetaData
		@see #mergeMetaData
	*/
	public native void addMetaData(String key, String value);
	/**
		 Add key/value pairs to the meta data that is sent to the slave.
		 If a certain key already existed, it will be overridden.
			@param values the meta data to add
				@short    Add key/value pairs to the meta data that is sent to the slave.
		@see #setMetaData
		@see #mergeMetaData
	*/
	// void addMetaData(const TQMap<TQString, TQString>& arg1); >>>> NOT CONVERTED
	/**
		 Add key/value pairs to the meta data that is sent to the slave.
		 If a certain key already existed, it will remain unchanged.
			@param values the meta data to merge
				@short    Add key/value pairs to the meta data that is sent to the slave.
		@see #setMetaData
		@see #addMetaData
	*/
	// void mergeMetaData(const TQMap<TQString, TQString>& arg1); >>>> NOT CONVERTED
	/**
			         		@short
	*/
	// TDEIO::MetaData outgoingMetaData(); >>>> NOT CONVERTED
	/**
		 Get meta data received from the slave.
		 (Valid when first data is received and/or slave is finished)
				@return the job's meta data

		@short    Get meta data received from the slave.
	*/
	// TDEIO::MetaData metaData(); >>>> NOT CONVERTED
	/**
		 Query meta data received from the slave.
		 (Valid when first data is received and/or slave is finished)
			@param key the key of the meta data to retrieve
				@return the value of the meta data, or null if the
         <code>key</code> does not exist

		@short    Query meta data received from the slave.
	*/
	public native String queryMetaData(String key);
	/**
		 Returns the processed size for this job.
				@short    Returns the processed size for this job.
		@see #processedSize
	*/
	public native long getProcessedSize();
	public Job(boolean showProgressInfo) {
		super((Class) null);
		newJob(showProgressInfo);
	}
	private native void newJob(boolean showProgressInfo);
	/**
		 Add a job that has to be finished before a result
		 is emitted. This has obviously to be called before
		 the finish signal is emitted by the slave.
			@param job the subjob to add
			@param inheritMetaData if true, the subjob will
		 inherit the meta data from this job.
		         		@short    Add a job that has to be finished before a result  is emitted.
	*/
	protected native void addSubjob(Job job, boolean inheritMetaData);
	protected native void addSubjob(Job job);
	/**
		 Mark a sub job as being done. If it's the last to
		 wait on the job will emit a result - jobs with
		 two steps might want to override slotResult
		 in order to avoid calling this method.
			@param job the subjob to add
		         		@short    Mark a sub job as being done.
	*/
	protected native void removeSubjob(Job job);
	/**
		 Overloaded version of removeSubjob
			@param job the subjob to remove
			@param mergeMetaData if set, the metadata received by the subjob is
		                      merged into this job.
			@param emitResultIfLast if this was the last subjob, emit result,
		                         i.e. terminate this job.
		         		@short    Overloaded version of removeSubjob
	*/
	protected native void removeSubjob(Job job, boolean mergeMetaData, boolean emitResultIfLast);
	/**
		 Utility function for inherited jobs.
		 Emits the percent signal if bigger than m_percent,
		 after calculating it from the parameters.
			@param processedSize the processed size in bytes
			@param totalSize the total size in bytes
		         		@short    Utility function for inherited jobs.
	*/
	protected native void emitPercent(long processedSize, long totalSize);
	/**
		 Utility function for inherited jobs.
		 Emits the speed signal and starts the timer for removing that info
			@param speed the speed in bytes/s
		         		@short    Utility function for inherited jobs.
	*/
	protected native void emitSpeed(long speed);
	/**
		 Utility function to emit the result signal, and suicide this job.
		 It first tells the observer to hide the progress dialog for this job.
		         		@short    Utility function to emit the result signal, and suicide this job.
	*/
	protected native void emitResult();
	/**
		 Set the processed size, does not emit processedSize
				@short    Set the processed size, does not emit processedSize
	*/
	protected native void setProcessedSize(long size);
	protected native int extraFlags();
	/**
		 Called whenever a subjob finishes.
		 Default implementation checks for errors and propagates
		 to parent job, then calls removeSubjob.
		 Override if you don't want subjobs errors to be propagated.
			@param job the subjob
				@short    Called whenever a subjob finishes.
		@see #result
	*/
	protected native void slotResult(Job job);
	/**
		 Forward signal from subjob.
			@param job the subjob
			@param speed the speed in bytes/s
				@short    Forward signal from subjob.
		@see #speed
	*/
	protected native void slotSpeed(Job job, long speed);
	/**
		 Forward signal from subjob.
			@param job the subjob
			@param msg the info message
				@short    Forward signal from subjob.
		@see #infoMessage
	*/
	protected native void slotInfoMessage(Job job, String msg);
	/**
		 Remove speed information.
		         		@short    Remove speed information.
	*/
	protected native void slotSpeedTimeout();
}
