#ifndef ksview_h
#define ksview_h

/* This file is part of ksirc
   Copyright (c) 2001 Malte Starostik <malte@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

// $Id$
//
#include "kstextview.h"

class KSircProcess;

class KSircView : public KSirc::TextView
{
	TQ_OBJECT
  
public:
	KSircView(KSircProcess *proc, TQWidget *parent, const char *name);
	virtual ~KSircView();

	virtual void clear();
	// returns the plain-text string added (for logging)
	TQString addLine(const TQString &pixmap, const TQColor &color, const TQString &text);
        void addRichText(const TQString &_text);
        void enableTimeStamps(bool enable);

	void setAcceptFiles(bool _acceptFiles) { m_acceptFiles = _acceptFiles; }
signals:
        void urlsDropped(const TQStringList&);
        void textDropped(const TQString&);

protected:
        virtual void contentsDragEnterEvent(TQDragEnterEvent *);
        virtual void contentsDragMoveEvent(TQDragMoveEvent *);
        virtual void contentsDropEvent(TQDropEvent *);

private:
	virtual bool linksEnabled() const { return true; }
    void openBrowser( const TQString &url );
    void copyLinkToClipboard( const TQString &url );
	static TQString makeTimeStamp();

	void saveURL( const TQString &url );

private slots:
	void anchorClicked(const TQMouseEvent *ev, const TQString &url);

	TQColor ircColor(int);

private:
	int m_lines;
	TQStringList m_timeStamps;
        bool m_acceptFiles;
	bool m_timestamps;
        KSircProcess *m_proc;
};
#endif
