/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_GUI_LISTBOXTEXT_H
#define TELLICO_GUI_LISTBOXTEXT_H

#include <tqlistbox.h>

namespace Tellico {
  namespace GUI {

/**
 * ListBoxText subclasses TQListBoxText so that @ref setText() can be made public,
 * and the font color can be changed
 *
 * @author Robby Stephenson
 */
class ListBoxText : public TQListBoxText {
public:
  ListBoxText(TQListBox* listbox, const TQString& text);
  ListBoxText(TQListBox* listbox, const TQString& text, TQListBoxItem* after);

  virtual int width(const TQListBox* box) const;
  virtual int height(const TQListBox* box) const;

  bool isColored() const { return m_colored; }
  void setColored(bool colored);
  void setText(const TQString& text);

protected:
  virtual void paint(TQPainter* painter);

private:
  bool m_colored;
};

  } // end namespace
} // end namespace

#endif
