/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2005 Francois Chazal <neptune3k@free.fr>
  Copyright (C) 2006-2007 Eike Hein <hein@kde.org>
*/


#ifndef MAIN_WINDOW_H
#define MAIN_WINDOW_H


#include "tab_bar.h"
#include "title_bar.h"
#include "dcop_interface.h"
#include "session.h"

#include <tqmap.h>
#include <tqcolor.h>
#include <tqtimer.h>
#include <tqlayout.h>
#include <tqwidget.h>
#include <tqapplication.h>
#include <tqwidgetstack.h>

#include <twin.h>
#include <tdeaction.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <dcopclient.h>
#include <kkeydialog.h>
#include <tdepopupmenu.h>
#include <twinmodule.h>
#include <tdemainwindow.h>
#include <tdeapplication.h>
#include <kglobalaccel.h>
#include <kpassivepopup.h>


#define CONFIG_FILE "yakuakerc"


class TDEAboutApplication;
class TDEAboutKDE;

class MainWindow : public TDEMainWindow, virtual public DCOPInterface
{
    TQ_OBJECT
  

    public:
        explicit MainWindow(TQWidget* parent = 0, const char* name = 0);
        ~MainWindow();

        int selectedSession();
        int selectedTerminal();

        const TQString sessionIdList();
        const TQString terminalIdList(int session_id);

        int tabPositionForSessionId(int session_id);
        int sessionIdForTabPosition(int position);

        void updateWindowMask();

        void showPopup(const TQString & text, int time = 5000);


    public slots:
        void slotAboutToQuit();

        void slotToggleState();

        void slotAddSession();
        void slotAddSessionTwoHorizontal();
        void slotAddSessionTwoVertical();
        void slotAddSessionQuad();
        void slotAddSession(Session::SessionType type);

        void slotRemoveSession();
        void slotRemoveSession(int session_id);

        void slotRemoveTerminal();
        void slotRemoveTerminal(int session_id);
        void slotRemoveTerminal(int session_id, int terminal_id);

        void slotSelectSession(int session_id);
        void slotSelectTabPosition(int position);

        void slotRenameSession(int session_id, const TQString& name);
        void slotInteractiveRename();

        const TQString slotSessionName();
        const TQString slotSessionName(int session_id);

        const TQString slotSessionTitle();
        const TQString slotSessionTitle(int session_id);
        const TQString slotSessionTitle(int session_id, int terminal_id);

        void slotSetSessionTitleText(const TQString& title);
        void slotSetSessionTitleText(int session_id, const TQString& title);
        void slotSetSessionTitleText(int session_id, int terminal_id, const TQString& title);

        void slotPasteClipboard();
        void slotPasteClipboard(int session_id);
        void slotPasteClipboard(int session_id, int terminal_id);

        void slotPasteSelection();
        void slotPasteSelection(int session_id);
        void slotPasteSelection(int session_id, int terminal_id);

        void slotRunCommandInSession(const TQString& command);
        void slotRunCommandInSession(int session_id, const TQString& command);
        void slotRunCommandInSession(int session_id, int terminal_id, const TQString& command);

        void slotSplitHorizontally();
        void slotSplitHorizontally(int session_id);
        void slotSplitHorizontally(int session_id, int terminal_id);

        void slotSplitVertically();
        void slotSplitVertically(int session_id);
        void slotSplitVertically(int session_id, int terminal_id);

        void slotFocusNextSplit();
        void slotFocusPreviousSplit();

        void slotPollMouse();


    signals:
        void updateBackground();


    protected:
        virtual void windowActivationChange(bool old_active);
        virtual void moveEvent(TQMoveEvent* e);
        bool queryClose();


    private:
        void createMenu();
        void updateWidthMenu();
        void updateHeightMenu();
        void updateScreenMenu();
        void createSessionMenu();
        void createTabsBar();
        void createTitleBar();
        void toggleMousePoll(bool poll);

        void initWindowProps();

        int getMouseScreen();
        TQRect getDesktopGeometry();

        bool full_screen;

        /* Animation step. */
        int step;

        /* Focus policy. */
        bool focus_policy;

        /* Maximum height value. */
        int max_height;
        int mask_height;

        /* Application border. */
        int margin;

        /* Interface modification timer. */
        TQTimer timer;
        TQTimer poller;

        /* Passive popup window. */
        KPassivePopup popup;

        /* Desktop information. */
        KWinModule desk_info;

        /* Main menu. */
        TDEPopupMenu* menu;
        TDEPopupMenu* session_menu;
        TDEPopupMenu* screen_menu;
        TDEPopupMenu* width_menu;
        TDEPopupMenu* height_menu;

        /* Global Key shortcut. */
        TDEGlobalAccel* global_key;

        /* Background widget. */
        TQWidget* back_widget;

        TabBar* tab_bar;
        TitleBar* title_bar;

        /* Inner konsole. */
        int selected_id;
        TQWidgetStack* widgets_stack;
        TQMap<int, Session*> sessions_stack;

        bool is_shutting_down;
        bool background_changed;
        bool use_translucency;

        enum PopupIDs { Focus };

        TDEAction* remove_tab_action;
        TDEAction* split_horiz_action;
        TDEAction* split_vert_action;
        TDEAction* remove_term_action;
        TDEToggleFullScreenAction* full_screen_action;

        KDialogBase* first_run_dialog;

        TDEAboutApplication* about_app;
        TDEAboutKDE* about_kde;


    private slots:
        void slotHandleRemoveSession(TDEAction::ActivationReason, TQt::ButtonState);
        void slotHandleHorizontalSplit(TDEAction::ActivationReason, TQt::ButtonState);
        void slotHandleVerticalSplit(TDEAction::ActivationReason, TQt::ButtonState);
        void slotHandleRemoveTerminal(TDEAction::ActivationReason, TQt::ButtonState);

        void slotInitSkin();
        void slotUpdateSize();
        void slotUpdateSize(int new_width, int new_height, int new_location);
        void slotUpdateTitle(const TQString& title);

        void slotIncreaseHeight();
        void slotDecreaseHeight();
        void slotSessionDestroyed(int id = -1);

        void slotSetAccessKey();
        void slotSetControlKeys();

        void slotIncreaseSizeW();
        void slotDecreaseSizeW();
        void slotIncreaseSizeH();
        void slotDecreaseSizeH();
        void slotSetFocusPolicy();
        void slotSetFocusPolicy(bool);
        void slotSetWidth(int);
        void slotSetHeight(int);
        void slotSetScreen(int);
        void slotSetFullScreen(bool state);
        void slotUpdateFullScreen();

        void slotUpdateBackgroundState();
        void slotUpdateSettings();
        void slotOpenSettingsDialog();

        void slotOpenFirstRunDialog();
        void slotFirstRunDialogOK();
        void slotFirstRunDialogCancel();

        void slotOpenAboutApp();
        void slotOpenAboutKDE();

        void slotDialogFinished();
};

#endif /* MAIN_WINDOW_H */
