// Maintainer: Max Howell <max.howell@methylblue.com>, (C) 2004
// Copyright:  See COPYING file that comes with this distribution
//
// Description: a popupmenu to control various features of Amarok
//              also provides Amarok's helpMenu

#ifndef AMAROK_ACTIONCLASSES_H
#define AMAROK_ACTIONCLASSES_H

#include "engineobserver.h"
#include "prettypopupmenu.h"
#include "sliderwidget.h"

#include <tdeaction.h>
#include <tdeactionclasses.h>
#include <tqguardedptr.h>

class TDEActionCollection;
class KHelpMenu;


namespace Amarok
{
    class Menu : public PrettyPopupMenu
    {
        TQ_OBJECT
  
        public:
            static Menu *instance();
            static TDEPopupMenu *helpMenu( TQWidget *parent = 0 );

            enum MenuIds {
                ID_CONF_DECODER,
                ID_SHOW_VIS_SELECTOR,
                ID_SHOW_COVER_MANAGER,
                ID_CONFIGURE_EQUALIZER,
                ID_RESCAN_COLLECTION
            };

        public slots:
            void slotActivated( int index );

        private slots:
            void slotAboutToShow();

        private:
            Menu();

            static KHelpMenu  *s_helpMenu;
    };


    class MenuAction : public TDEAction
    {
        public:
            MenuAction( TDEActionCollection* );
            virtual int plug( TQWidget*, int index = -1 );
    };


    class PlayPauseAction : public TDEToggleAction, public EngineObserver
    {
        public:
            PlayPauseAction( TDEActionCollection* );
            virtual void engineStateChanged( Engine::State, Engine::State = Engine::Empty );
    };

    class AnalyzerContainer : public TQWidget
    {
        public:
            AnalyzerContainer( TQWidget *parent );
        protected:
            virtual void resizeEvent( TQResizeEvent* );
            virtual void mousePressEvent( TQMouseEvent* );
            virtual void contextMenuEvent( TQContextMenuEvent* );
        private:
            void changeAnalyzer();
            TQWidget *m_child;
    };

    class AnalyzerAction : public TDEAction
    {
        public:
            AnalyzerAction( TDEActionCollection* );
            virtual int plug( TQWidget *, int index = -1 );
    };


    class VolumeAction : public TDEAction, public EngineObserver
    {
        public:
            VolumeAction( TDEActionCollection* );
            virtual int plug( TQWidget *, int index = -1 );
        private:
            void engineVolumeChanged( int value );
            TQGuardedPtr<Amarok::VolumeSlider> m_slider;
    };


    class ToggleAction : public TDEToggleAction
    {
        public:
            ToggleAction( const TQString &text, void ( *f ) ( bool ), TDEActionCollection* const ac, const char *name );

            virtual void setChecked( bool b );

            virtual void setEnabled( bool b );

        private:
            void ( *m_function ) ( bool );
    };

    class SelectAction : public TDESelectAction
    {
        public:
            SelectAction( const TQString &text, void ( *f ) ( int ), TDEActionCollection* const ac, const char *name );

            virtual void setCurrentItem( int n );

            virtual void setEnabled( bool b );

            virtual void setIcons( TQStringList icons );

            virtual TQString currentText() const;

            TQStringList icons() const;

            TQString currentIcon() const;

        private:
            void ( *m_function ) ( int );
            TQStringList m_icons;
    };


    class RandomAction : public SelectAction
    {
        public:
            RandomAction( TDEActionCollection *ac );
            virtual void setCurrentItem( int n );
    };

    class FavorAction : public SelectAction
    {
        public:
            FavorAction( TDEActionCollection *ac );
    };

    class RepeatAction : public SelectAction
    {
        public:
            RepeatAction( TDEActionCollection *ac );
    };

    class BurnMenu : public TDEPopupMenu
    {
            TQ_OBJECT
  

        public:
            enum MenuIds {
                CURRENT_PLAYLIST,
                SELECTED_TRACKS
            };

            static TDEPopupMenu *instance();

        private slots:
            void slotAboutToShow();
            void slotActivated( int index );

        private:
            BurnMenu();
    };


    class BurnMenuAction : public TDEAction
    {
        public:
            BurnMenuAction( TDEActionCollection* );
            virtual int plug( TQWidget*, int index = -1 );
    };

    class StopMenu : public TDEPopupMenu
    {
            TQ_OBJECT
  

        public:
            enum MenuIds {
                NOW,
                AFTER_TRACK,
                AFTER_QUEUE
            };

            static TDEPopupMenu *instance();

        private slots:
            void slotAboutToShow();
            void slotActivated( int index );

        private:
            StopMenu();
    };


    class StopAction : public TDEAction
    {
        public:
            StopAction( TDEActionCollection* );
            virtual int plug( TQWidget*, int index = -1 );
    };

} /* namespace Amarok */


#endif /* AMAROK_ACTIONCLASSES_H */

