/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef BASKETPROPERTIES_H
#define BASKETPROPERTIES_H

#include <kdialogbase.h>
#include <tqmap.h>
#include <tqstring.h>

class TDEIconButton;
class TQLineEdit;
class TQComboBox;
class TQVButtonGroup;
class KIntNumInput;
class KKeyButton;
class TDEShortcut;

class Basket;
class KColorCombo2;

/** The dialog that hold basket settings.
  * @author Sbastien Laot
  */
class BasketPropertiesDialog : public KDialogBase
{
  TQ_OBJECT
  
  public:
	BasketPropertiesDialog(Basket *basket, TQWidget *parent = 0);
	~BasketPropertiesDialog();
	void polish();
	void applyChanges();
  protected slots:
	void slotApply();
	void slotOk();
	void capturedShortcut(const TDEShortcut &shortcut);
	void selectColumnsLayout();
  private:
	Basket        *m_basket;
	TDEIconButton   *m_icon;
	TQLineEdit     *m_name;
	TQComboBox     *m_backgroundImage;
	KColorCombo2  *m_backgroundColor;
	KColorCombo2  *m_textColor;
	TQVButtonGroup *m_disposition;
	KIntNumInput  *m_columnCount;
	KKeyButton    *m_shortcut;
	TQVButtonGroup *m_shortcutRole;
	TQMap<int, TQString> m_backgroundImagesMap;
};

#endif // BASKETPROPERTIES_H
