/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2008-02-15
 * Description : a led indicator.
 * 
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqpixmap.h>
#include <tqstring.h>

// KDE includes.

#include <tdeglobalsettings.h>
#include <tdestandarddirs.h>

// Local includes.

#include "statusled.h"
#include "statusled.moc"

namespace Digikam
{

StatusLed::StatusLed(TQWidget *parent)
         : TQLabel(parent)
{
    setLedColor(Gray);
    setFocusPolicy(TQWidget::NoFocus);
}

StatusLed::~StatusLed()
{
}

void StatusLed::setLedColor(LedColor color)
{
    m_color = color;

    TQString file;
    switch(m_color)
    {
        case Green:
            file = TQString("indicator-green");
            break;

        case Red:
            file = TQString("indicator-red");
            break;

        default:
            file = TQString("indicator-gray");
            break;
    }

    TDEGlobal::dirs()->addResourceType(file.ascii(), TDEGlobal::dirs()->kde_default("data") + "digikam/data");
    TQString directory = TDEGlobal::dirs()->findResourceDir(file.ascii(), file + TQString(".png"));
    setPixmap(TQPixmap(directory + file + TQString(".png")));
}

StatusLed::LedColor StatusLed::ledColor() const
{
    return m_color;
}

}  // namespace Digikam

