/* ============================================================
 * File  : cameraiconview.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-01-23
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqrect.h>
#include <tqpalette.h>
#include <tqpoint.h>
#include <tqpopupmenu.h>
#include <tqvaluevector.h>
// KDE
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdestandarddirs.h>
#include <ktrader.h>
#include <kservice.h>
// Local
#include "gpfileiteminfo.h"
#include "gpfileiteminfodlg.h"
#include "cameraiconitem.h"
#include "cameraiconview.h"
#include "cameraui.h"

namespace KIPIKameraKlientPlugin
{

const int MAXICONITEMS = 307;
const int THUMBSIZE = 120;

class CameraIconViewPrivate {

public:
    TQPixmap imagePix;
    TQPixmap audioPix;
    TQPixmap videoPix;
    TQPixmap unknownPix;
};

CameraIconView::CameraIconView(TQWidget *parent) : ThumbView(parent) {
    d = new CameraIconViewPrivate;
    setThumbnailSize();
}

CameraIconView::~CameraIconView() {
    delete d;
}

void CameraIconView::setThumbnailSize() {
    int w = THUMBSIZE;
    int h = THUMBSIZE;
    TQString iconfile = locate("data", "documents");
    TQImage image(iconfile);
    double scale = double(w-10) / double(image.width());
    image = image.smoothScale(w-10, h-10, TQImage::ScaleMin);
    TQPixmap pix(w, h);
    pix.fill(colorGroup().base());
    TQPainter p(&pix);
    p.fillRect(0, 0, w, h, TQBrush(colorGroup().base()));
    if(!image.isNull()) {
        p.drawImage((w-image.width())/2, (h-image.height())/2, image);
    }
    p.end();
    d->imagePix = pix;
    createPixmap(d->imagePix, "image-x-generic", scale);
    d->audioPix = pix;
    createPixmap(d->audioPix, "audio-x-generic", scale);
    d->videoPix = pix;
    createPixmap(d->videoPix, "video-x-generic", scale);
    d->unknownPix = pix;
    createPixmap(d->unknownPix, "text-x-generic", scale);
}

void CameraIconView::createPixmap(TQPixmap& pix, const TQString& icon, double scale) {
    TQString iconfile = locate("data", icon);
    TQImage mimeImg(iconfile);
    mimeImg = mimeImg.smoothScale((int) (mimeImg.width()*scale), (int) (mimeImg.height()*scale), TQImage::ScaleMin);
    int w = THUMBSIZE;
    int h = THUMBSIZE;
    TQPainter p(&pix);
    if (!mimeImg.isNull()) {
        p.drawImage((w-mimeImg.width())/2, (h-mimeImg.height())/2, mimeImg);
    }
    p.end();
}

CameraIconItem* CameraIconView::addItem(const GPFileItemInfo* fileInfo) {
    TQPixmap& pix = d->unknownPix;
    if(fileInfo->mime.contains("image")) {
        pix = d->imagePix;
    } else if(fileInfo->mime.contains("audio")) {
        pix = d->audioPix;
    } else if(fileInfo->mime.contains("video")) {
        pix = d->videoPix;
    } else {
        pix = d->unknownPix;
    } 
    CameraIconItem *iconItem = new CameraIconItem(this, fileInfo, pix);
    return iconItem;
}

void CameraIconView::clear() {
    ThumbView::clear();
    emit signalCleared();
}

void CameraIconView::setThumbnail(CameraIconItem* iconItem, const TQImage& thumbnail) {
    if (!iconItem) {
	return;
    }
    iconItem->setPixmap(thumbnail);
}

void CameraIconView::markDownloaded(CameraIconItem* iconItem) {
    if (!iconItem) {
	return;
    }
    GPFileItemInfo *fileInfo = const_cast<GPFileItemInfo*>(iconItem->fileInfo());
    fileInfo->downloaded = 1;
    iconItem->repaint();
}

}  // NameSpace KIPIKameraKlientPlugin

#include "cameraiconview.moc"
