/***************************************************************************
 * eventsignal.cpp
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "eventsignal.h"

#include "variant.h"
#include "qtobject.h"

#include <tqmetaobject.h>
#include <private/tqucom_p.h> // for the TQt TQUObject API.

using namespace Kross::Api;

EventSignal::EventSignal(const TQString& name, TQObject* sender, TQCString signal)
    : Event<EventSignal>(name)
    , m_sender(sender)
    , m_signal(signal) //TQObject::normalizeSignalSlot(signal)
{
}

EventSignal::~EventSignal()
{
}

const TQString EventSignal::getClassName() const
{
    return "Kross::Api::EventSignal";
}

Object::Ptr EventSignal::call(const TQString& /*name*/, TDESharedPtr<List> arguments)
{
#ifdef KROSS_API_EVENTSIGNAL_CALL_DEBUG
    krossdebug( TQString("EventSignal::call() m_signal=%1 arguments=%2").arg(m_signal).arg(arguments->toString()) );
#endif

    TQString n = m_signal;

    if(n.startsWith("2")) // Remove prefix of TQ_SIGNAL-macros
        n.remove(0,1);

    int signalid = m_sender->metaObject()->findSignal(n.latin1(), false);
    if(signalid < 0)
        throw new Exception(TQString("No such signal '%1'.").arg(n));

    TQUObject* uo = QtObject::toTQUObject(n, arguments);
    m_sender->tqt_emit(signalid, uo); // emit the signal
    delete [] uo;

    return new Variant( TQVariant(true) );
}
