/***************************************************************************
 *   Copyright (C) 2005 by Florian Roth   *
 *   florian@synatic.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef _CONFIGDIALOG_H_
#define _CONFIGDIALOG_H_

#include <tqdialog.h>
#include <kpushbutton.h>
#include <tdelistview.h>
#include <knuminput.h>
#include <tdeconfig.h>
#include <tqptrdict.h>
#include <tqlistbox.h>
#include <tdeactionselector.h>
#include <tqcheckbox.h>
#include <kcombobox.h>

class LinkEntry{
  public:
    LinkEntry(TQString name, TQString url, TQString icon);
    
    ~LinkEntry(){}
    
    TQString name;
    TQString url;
    TQString icon;
};
 
class ConfigDialog : public TQDialog
{
  TQ_OBJECT
  
  
  public:
    ConfigDialog(TQWidget *parent = 0, const char *name = 0);
    ~ConfigDialog();
    
  protected:
    KPushButton *ok;
    KPushButton *cancel;
  
    KPushButton *link_create;
    KPushButton *link_delete;
    KPushButton *link_edit;
    KPushButton *link_up;
    KPushButton *link_down;
    
    KPushButton *install_theme;
    
    KIntSpinBox *max_entries;
    KIntSpinBox *max_actions;
    
    TQCheckBox *animate;
    TQCheckBox *servicemenus;
    TQCheckBox *showframe;
    
    TDEListView *link_list;
    
    KComboBox *themes;
    
    TQCString topWidgetName;
    
    TDEActionSelector *actionSelector;
    
    TQPtrDict<LinkEntry> linkList;
    
    TDEConfig *config;
    TDEConfig *iconConfig;
    
  protected slots:
    void accept();
    void createLink();
    void deleteLink();
    void editLink();
    void editLink(TQListViewItem *item);
    void moveLinkUp();
    void moveLinkDown();
    void updateArrows();
    void installTheme();
  
  private:
    void loadAvailableActions();
    void loadThemes();
};

class ActionListItem : public TQListBoxPixmap
{
  public:
    ActionListItem(TQListBox *listbox, const TQString &action, const TQString &text, const TQPixmap &pixmap);
    ~ActionListItem(){}
  
    const TQString action() { return act; }
    void setAction(const TQString act){ ActionListItem::act = act; }
  
  private:
    TQString act;
};

#endif
