/***************************************************************************
                          wizard.cpp - Widget providing a wizard 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */
#include <tdeprocess.h>

/* QT INCLUDES */
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqwizard.h>
#include <tqdialog.h>

/* OTHER INCLUDES */
#include <myprocess.h>
#include <kommanderfactory.h>
#include <specials.h>
#include "wizard.h"


Wizard::Wizard(TQWidget *a_parent, const char *a_name, bool a_modal, int a_flags)
  : TQWizard(a_parent, a_name, a_modal, a_flags), KommanderWidget(this)
{
  TQStringList states;
  states << "default";
  states << "initialization";
  states << "destroy";
  setStates(states);
  setDisplayStates(states);

  connect(this, TQ_SIGNAL(helpClicked()), TQ_SLOT(runHelp()));
}

Wizard::~Wizard()
{
  if (!inEditor)
    destroy();
}

TQString Wizard::currentState() const
{
  return TQString("default");
}

bool Wizard::isKommanderWidget() const
{
  return true;
}

TQStringList Wizard::associatedText() const
{
  return KommanderWidget::associatedText();
}

void Wizard::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void Wizard::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString Wizard::populationText() const
{
  return KommanderWidget::populationText();
}

void Wizard::populate()
{
  TQString txt = KommanderWidget::evalAssociatedText(populationText());
//FIXME: implement me
}

void Wizard::setWidgetText(const TQString &a_text)
{
  setCaption(a_text);
  emit widgetTextChanged(a_text);
}

void Wizard::initialize()
{
  setFinishEnabled(page(pageCount() - 1), true);
  const TQStringList assoc = associatedText();
  if (assoc.count() > 1 && !assoc[1].isEmpty()) 
  {
    MyProcess proc(this);
    proc.run( KommanderWidget::evalAssociatedText(assoc[1]) );
  }
}

void Wizard::destroy()
{
  const TQStringList assoc = associatedText();
  if (assoc.count() > 2 && !assoc[2].isEmpty()) 
  {
    MyProcess proc(this);
    proc.run(KommanderWidget::evalAssociatedText(assoc[2]));
  }
}

void Wizard::exec()
{
  TQWizard::exec();
  emit finished();
}

void Wizard::show()
{
  TQWizard::show();
  if (!inEditor)
    initialize();
}

void Wizard::runHelp()
{
  if (helpAction() == Command)
  {
    TDEProcess proc;
    proc << helpActionText();
    proc.start(TDEProcess::DontCare, TDEProcess::NoCommunication);
  }
  else if (helpAction() == Dialog)
  {
    KommanderFactory::loadPlugins();
    TQDialog *dialog = (TQDialog *)KommanderFactory::create(helpActionText());
    dialog->exec();
    delete dialog;
  }
}

Wizard::HelpAction Wizard::helpAction() const
{
  return m_helpAction;
}

void Wizard::setHelpAction(HelpAction a_helpAction)
{
  m_helpAction = a_helpAction;
}

TQString Wizard::helpActionText() const
{
  return m_helpActionText;
}

void Wizard::setHelpActionText(const TQString& a_helpActionText)
{
  m_helpActionText = a_helpActionText;
}


void Wizard::showEvent(TQShowEvent *e)
{
  TQWizard::showEvent(e);
  emit widgetOpened();
}

void Wizard::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

TQString Wizard::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::setEnabled:
      setFinishEnabled(page(pageCount() - 1), args[0] != "false");
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}



#include "wizard.moc"
