/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-11-17
 * Description : a tab to display metadata information of images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef IMAGEPROPERTIESMETADATATAB_H
#define IMAGEPROPERTIESMETADATATAB_H

// TQt includes.

#include <tqwidget.h>
#include <tqcstring.h>

// KDE includes.

#include <kurl.h>

// Local includes.

#include "digikam_export.h"
#include "navigatebartab.h"

namespace Digikam
{

class ImagePropertiesMetadataTabPriv;

class DIGIKAM_EXPORT ImagePropertiesMetaDataTab : public NavigateBarTab
{
    Q_OBJECT
  

public:

    ImagePropertiesMetaDataTab(TQWidget* parent, bool navBar=true);
    ~ImagePropertiesMetaDataTab();

    void setCurrentURL(const KURL& url=KURL());
    void setCurrentData(const TQByteArray& exifData=TQByteArray(), 
                        const TQByteArray& iptcData=TQByteArray(), 
                        const TQString& filename=TQString());

private:

    ImagePropertiesMetadataTabPriv* d;
};

}  // NameSpace Digikam

#endif /* IMAGEPROPERTIESMETADATATAB_H */
