/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CINPUTDIALOG_H
#define CINPUTDIALOG_H

//KDE includes
#include <kdialog.h>

class TQTextEdit;
class TQWidget;

/** This is a small input dialog with
 * a multiline edit for the text input.
  * @author The BibleTime team
  */
class CInputDialog : public KDialog  {
	Q_OBJECT
  
public:
	CInputDialog(const TQString& caption, const TQString& description, const TQString& text, TQWidget *parent=0, const char *name=0, const bool modal = true);
	/**
	* A static function to get some using CInputDialog.
	*/
	static const TQString getText( const TQString& caption, const TQString& description, const TQString& text = TQString(), bool* ok = 0, TQWidget* parent = 0, bool modal = true);
	/**
	* Returns the text entered at the moment.
	*/
	const TQString text();
	// ~CInputDialog();

private:
	TQTextEdit* m_editWidget;
};

#endif
