/***************************************************************************
 *   Copyright (C) 2005 by Christian Hubinger   *
 *   e9806056@student.tuwien.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KMFIPTWATCHER_H
#define KMFIPTWATCHER_H

#include <tqobject.h>

/**
@author Christian Hubinger
*/

class TQTimer;
class KMFIPTDoc;
class IPTChain;
class IPTable;
class IPTRule;
class IPTRuleOption;

class KMFIPTWatcher : public TQObject
{
Q_OBJECT
  
public:
    KMFIPTWatcher(TQObject *parent = 0, const char *name = 0);

    ~KMFIPTWatcher();

public slots:
	void slotQueryDetails( bool );

private slots:
	void timeout();
	void worked();


private:
	void go();
	void queryExtendedInfo();
	void queryNumRulesInChain( const TQString& /*table*/, const TQString& /*Chain*/, KMFIPTDoc* /* doc */ );
	void queryChainsInTable( const TQString& /*table*/, KMFIPTDoc* /* doc */ );
	
	TQTimer *m_timer;
	bool m_queryExtendedInfo;

	void fetchChainPolicy( IPTChain* );
	void fetchRulesInChain( IPTChain* );
	void fetchRulesProperties( IPTRule*, int );
	
	KMFIPTDoc *m_doc;
signals:
	void sigUpdateIPTDoc( KMFIPTDoc* );
	void sigUpdateActive( bool );
	void sigUpdateRuleCount( const TQString& /*table*/, const TQString& /*Chain*/, int );

};

#endif
