/***************************************************************************
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFPFINSTALLER_H
#define KMFPFINSTALLER_H
#include <tqobject.h>
#include <tqpixmap.h>
#include <tqstringlist.h>

#include <tdeparts/part.h>
#include <tdeparts/plugin.h>
#include <tdeparts/factory.h>
#include <kxmlgui.h>



#include "../../core/kmfplugin.h"
#include "../../core/kmfinstallerinterface.h"

#include "../../kmyfirewall.h"

class TQString;
class TQLabel;
class TQPushButton;
class TQGridLayout;
class KTempFile;
class TDEInstance;


namespace KMF {

class KMFProcOut;
class KMFError;
class KMFTarget;
class KMFErrorHandler;
class KMFCompilerInterface;

class KMFPFInstaller :  public KMFPlugin, public KMFInstallerInterface {
	Q_OBJECT
  

public:
	KMFPFInstaller( TQObject* parent = 0, const char* name = 0 );
	~KMFPFInstaller();
	virtual KMFCompilerInterface* compiler();
 	virtual void cmdRunFW();
 	virtual void cmdStopFW();
 	virtual void cmdInstallFW();
 	virtual void cmdUninstallFW();
 	virtual void cmdShowRunningConfig( const TQString& );
 	virtual void generateInstallerPackage( KMFTarget*, const KURL& );
 	virtual const TQString& osName() const {
		return m_osName;
	}
	virtual const TQString& osGUIName() const {
		return m_osGUIName;
	}
 	virtual TQValueList<KMFCompilerInterface*>* compilers();
 	
 	

public slots:


private:    // functions
	TQString m_osName;
	TQString m_osGUIName;
	KMFProcOut* execWidget();

/*	void loadIcons();
	
	KMFError* createInitScript( const TQString& file, const TQString& systemtype );

	
	TQString cmdShowAll();
	TQString cmdShowFilter();
	TQString cmdShowNat();
	TQString cmdShowMangle();
	void installRemote();
	
	
	void parseFileHeaders( const TQString& source_file_path, const TQString& target_file_path ); 
	void writeBase64DataField( const TQString& source_file_path, const TQString& target_file_path, const TQString& data );*/
	
	
private:
	KMFProcOut *m_execWidget;
	TQString m_script;
	
};




class KMFPFInstallerFactory : public KLibFactory {
	Q_OBJECT
  
public:
	KMFPFInstallerFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFPFInstallerFactory() {};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = TQOBJECT_OBJECT_NAME_STRING,
	                               const TQStringList &args = TQStringList() );
};
}

#endif // KMFPFINSTALLER_H
