/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/


#ifndef KMFLISTVIEW_H
#define KMFLISTVIEW_H

#include <tdelistview.h>


// QT includes
#include <tqptrlist.h>
#include <tqintdict.h>
#include <tqdict.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>
#include <tqpixmap.h>
#include <tquuid.h>
#include <tqguardedptr.h>
// Project includes

/**
@author Christian Hubinger
*/
class TDEListViewItem;
namespace KMF {
class NetfilterObject;
class IPTable;
class IPTChain;
class IPTRule;
class IPTRuleOption;
class KMFListViewItem;


class KDE_EXPORT KMFListView : public TDEListView {
	Q_OBJECT
  
public:
	KMFListView( TQWidget *parent = 0, const char *name = 0 );

	~KMFListView();

	KMFListViewItem* getRootItem();
	void clearAllItems();

public slots:
	void slotLoadNode( NetfilterObject* );
	void slotUpdateView();
	void slotUpdateView( NetfilterObject* );
	KMFListViewItem* findKMFItem( const TQString& text, int column, const TQUuid& obj_id, bool exact = true, KMFListViewItem* from = 0 );
	KMFListViewItem* findKMFItem( const TQString& text1, int column1,const TQString& text2, int column2, const TQUuid& obj_id );

signals:
	void sigUpdateItem( int );

private:
	void loadIcons();
	void setupTableView( IPTable* );
	void setupChainView( IPTChain*, KMFListViewItem* );
	void setupRuleView( IPTRule*, KMFListViewItem* );
	void setupRuleOptionView( IPTRuleOption*, KMFListViewItem* );

private slots:
	void slotChangeRoot( TQListViewItem* );

private: // data
	TQGuardedPtr<NetfilterObject> m_NetfilterObject;
	IPTable *m_table;
	TQString cast_error;

	TQStringList m_existed_chains;
	TQDict< TQStringList > m_dict_existed_rules;

	bool m_show_desc, m_show_cmds, m_show_objectID;

	TQPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
	        icon_target, icon_queue, icon_new, icon_disabled, icon_feed, icon_fwd, icon_fwds, icon_user, icon_builtin, icon_table;
signals:
	void sigLoadNode( NetfilterObject* );
};
}
#endif
