//
// C++ Interface: kmfnetworkwidget
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFNETWORKWIDGET_H
#define KMFNETWORKWIDGET_H

#include "kmyfirewallnetworkwidget.h"

// QT includes
#include <tqwidget.h>
#include <tqguardedptr.h>

// KDE includes
#include <kdemacros.h>

// project includes
#include "../core/kmfnetzone.h"
#include "../core/ipaddress.h"

class TQFocusEvent;

/**
@author Christian Hubinger
*/

namespace KMF {
class KDE_EXPORT KMFNetworkWidget : public KMyFirewallNetworkWidget {
	Q_OBJECT
  
public:
	KMFNetworkWidget(TQWidget *parent = 0, const char *name = 0);
	~KMFNetworkWidget();
	
	void loadZone( KMFNetZone* );
	void allowEdit( bool );
private slots:
	void slotAddressChanged( const TQString& );
	void slotDescriptionChanged();
	void slotShortMaskChanged( int );
	void slotZoneDeleted();
	
protected:
	void focusOutEvent( TQFocusEvent * );
	
private:
	void blockAllSignals( bool );	

private:
	TQGuardedPtr<KMFNetZone> m_zone;
	bool m_allowEdit;



signals:
	void sigZoneChanged( KMFNetZone* );
};
}
#endif
