/***************************************************************************
 begin                : Thu Aug 29 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleedittargetmark.h"

// QT includes
#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqspinbox.h> 
// KDE includes
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdelocale.h> 

// MY includes
#include "../../core/xmlnames.h"
#include "../../core/iptrule.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"

namespace KMF {
KMFRuleEditTargetMark::KMFRuleEditTargetMark( TQWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTargetMark( parent, name, fl ) {}
KMFRuleEditTargetMark::~KMFRuleEditTargetMark() {}

void KMFRuleEditTargetMark::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditTargetMark::loadRule(IPTRule* rule)" << endl;
	if ( rule == 0 ) {
		kdDebug() << "void KMFRuleEditTargetMark::loadRule(IPTRule* rule)\nrule == 0\nThis is a bug ;-)" << endl;
		return ;
	}
	m_rule = rule;
	IPTRuleOption *opt = m_rule->getOptionForName( "target_mark_opt" );
	TQStringList vals = opt->getValues();
	TQString val = "";
	val = *vals.at(0);
	if ( val != XML::Undefined_Value && !val.isEmpty() && val != XML::BoolOff_Value ) {
		c_use_mark->setChecked( true );
		int num = val.toInt();
		sb_mark->setValue( num );
	} else {
		c_use_mark->setChecked( false );
	}
}
void KMFRuleEditTargetMark::accept() {
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 Mark Target Option").arg( m_rule->name() ) 
	);
	kdDebug() << "void KMFRuleEditTargetMark::accept()" << endl;
	TQPtrList<TQString>* options = new TQPtrList<TQString>;
	TQString* name = new TQString( "target_mark_opt" );
	if ( c_use_mark->isChecked() ) {
		int mark = sb_mark->value();
		kdDebug() << "Will set mark" << mark << endl;
		TQString* opt = new TQString( "" );
		TQString val = val.setNum( mark );
		opt->append( val );
		options->append( opt );
	}
	
	
	m_rule->addTargetOption( *name, *options );
	KMFUndoEngine::instance()->endTransaction();
	emit sigDocumentChanged();
}

void KMFRuleEditTargetMark::slotHelp() {
	kdDebug() << "void KMFRuleEditTargetMark::slotHelp()" << endl;
	kapp->invokeHelp( "targets" );
}
void KMFRuleEditTargetMark::reject() {
	kdDebug() << "void KMFRuleEditTargetMark::reject()" << endl;
	loadRule(m_rule);
	emit sigHideMe();
}

}

#include "kmfruleedittargetmark.moc"
