/***************************************************************************
                          newlabel.h  -  description
                             -------------------
    begin                : Son Mai 5 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NEWLABEL_H
#define NEWLABEL_H

#include <tqdialog.h>
#include <tqwidget.h>

#include "definition.h"

class TQVBoxLayout;
class TQHBoxLayout; 
class TQGridLayout; 
class TQCheckBox;
class TQComboBox;
class KComboBox;
class KPushButton;
class TQLabel;
class TQString;
class LabelPreview;
class NewLabel : public TQDialog
{ 
    Q_OBJECT
  
    public:
        NewLabel( TQWidget* parent = 0, const char* name = 0, bool change = FALSE, WFlags fl = 0 );
        ~NewLabel();

        int labelId() const { return curid; }
        bool empty() const;

        void setLabelId( int id );

        static bool isInCombo( TQComboBox* combo, TQString text );

    private slots:
        void updateType();
        void updateText();
        void add();
        
    private:
        void fillData();

        TQLabel* TextLabel1;
        TQLabel* TextLabel2;
        TQLabel* TextLabel3;
        TQCheckBox* checkEmpty;
        KComboBox* comboProducer;
        KComboBox* comboType;
        KPushButton* buttonOwnFormat;
        TQLabel* TextLabel4;
        KPushButton* buttonOk;
        KPushButton* buttonCancel;
        LabelPreview* preview;
        TQStringList* types;
        
    protected:
        int curid;
        TQVBoxLayout* NewLabelLayout;
        TQHBoxLayout* Layout5;
        TQHBoxLayout* Layout2;
        TQHBoxLayout* Layout1;
};

#endif // NEWLABEL_H
