/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;
import java.util.HashMap;

class TextEdit  extends TQMainWindow
{


private    TQAction actionTextBold,
	actionTextUnderline,
	actionTextItalic,
	actionTextColor,
	actionAlignLeft,
	actionAlignCenter,
	actionAlignRight,
	actionAlignJustify;
    TQComboBox comboStyle,
	comboFont,
	comboSize;
private    TQTabWidget tabWidget;
private    HashMap filenames = new HashMap();



TextEdit( )
{
	this(null, null);
}

TextEdit( TQWidget parent, String name )
{
    super( parent, name );
    setupFileActions();
    setupEditActions();
    setupTextActions();

    tabWidget = new TQTabWidget( this );
    connect( tabWidget, SIGNAL(" currentChanged( TQWidget  )"),
	     this, SLOT(" editorChanged( TQWidget  )") );
    setCentralWidget( tabWidget );

    if ( tqApp().args().length == 0 ) {
	load( "example.html" );
    } else {
	for ( int i = 0; i < tqApp().args().length; ++i )
	    load( tqApp().args()[ i ] );
    }
}

void setupFileActions()
{
    TQToolBar tb = new TQToolBar( this );
    tb.setLabel( "File Actions" );
    TQPopupMenu menu = new TQPopupMenu( this );
    menuBar().insertItem( tr( "&File" ), menu );

    TQAction a;
    a = new TQAction( tr( "New" ), new TQIconSet(new TQPixmap( "filenew.xpm" )), tr( "&New..." ), new TQKeySequence(CTRL + Key_N), this, "fileNew" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" fileNew()") );
    a.addTo( tb );
    a.addTo( menu );
    a = new TQAction( tr( "Open" ), new TQIconSet(new TQPixmap( "fileopen.xpm" )), tr( "&Open..." ), new TQKeySequence(CTRL + Key_O), this, "fileOpen" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" fileOpen()") );
    a.addTo( tb );
    a.addTo( menu );
    menu.insertSeparator();
    a = new TQAction( tr( "Save" ), new TQIconSet(new TQPixmap( "filesave.xpm" )), tr( "&Save..." ), new TQKeySequence(CTRL + Key_S), this, "fileSave" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" fileSave()") );
    a.addTo( tb );
    a.addTo( menu );
    a = new TQAction( tr( "Save As" ), new TQIconSet(new TQPixmap()), tr( "Save &As..." ), new TQKeySequence(0), this, "fileSaveAs" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" fileSaveAs()") );
    a.addTo( menu );
    menu.insertSeparator();
    a = new TQAction( tr( "Print" ), new TQIconSet(new TQPixmap( "fileprint.xpm" )), tr( "&Print..." ), new TQKeySequence(CTRL + Key_P), this, "filePrint" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" filePrint()") );
    a.addTo( tb );
    a.addTo( menu );
    a = new TQAction( tr( "Close" ), new TQIconSet(new TQPixmap()), tr( "&Close" ), new TQKeySequence(0), this, "fileClose" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" fileClose()") );
    a.addTo( menu );
    a = new TQAction( tr( "Exit" ), new TQIconSet(new TQPixmap()), tr( "E&xit" ), new TQKeySequence(0), this, "fileExit" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" fileExit()") );
    a.addTo( menu );
}

void setupEditActions()
{
    TQToolBar tb = new TQToolBar( this );
    tb.setLabel( "Edit Actions" );
    TQPopupMenu menu = new TQPopupMenu( this );
    menuBar().insertItem( tr( "&Edit" ), menu );

    TQAction a;
    a = new TQAction( tr( "Undo" ), new TQIconSet(new TQPixmap( "editundo.xpm" )), tr( "&Undo" ), new TQKeySequence(CTRL + Key_Z), this, "editUndo" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" editUndo()") );
    a.addTo( tb );
    a.addTo( menu );
    a = new TQAction( tr( "Redo" ), new TQIconSet(new TQPixmap( "editredo.xpm" )), tr( "&Redo" ), new TQKeySequence(CTRL + Key_Y), this, "editRedo" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" editRedo()") );
    a.addTo( tb );
    a.addTo( menu );
    menu.insertSeparator();
    a = new TQAction( tr( "Copy" ), new TQIconSet(new TQPixmap( "editcopy.xpm" )), tr( "&Copy" ), new TQKeySequence(CTRL + Key_C), this, "editCopy" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" editCopy()") );
    a.addTo( tb );
    a.addTo( menu );
    a = new TQAction( tr( "Cut" ), new TQIconSet(new TQPixmap( "editcut.xpm" )), tr( "Cu&t" ), new TQKeySequence(CTRL + Key_X), this, "editCut" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" editCut()") );
    a.addTo( tb );
    a.addTo( menu );
    a = new TQAction( tr( "Paste" ), new TQIconSet(new TQPixmap( "editpaste.xpm" )), tr( "&Paste" ), new TQKeySequence(CTRL + Key_V), this, "editPaste" );
    connect( a, SIGNAL(" activated()"), this, SLOT(" editPaste()") );
    a.addTo( tb );
    a.addTo( menu );
}

void setupTextActions()
{
    TQToolBar tb = new TQToolBar( this );
    tb.setLabel( "Format Actions" );
    TQPopupMenu menu = new TQPopupMenu( this );
    menuBar().insertItem( tr( "F&ormat" ), menu );

    comboStyle = new TQComboBox( false, tb );
    comboStyle.insertItem( "Standard" );
    comboStyle.insertItem( "Bullet List (Disc)" );
    comboStyle.insertItem( "Bullet List (Circle)" );
    comboStyle.insertItem( "Bullet List (Square)" );
    comboStyle.insertItem( "Ordered List (Decimal)" );
    comboStyle.insertItem( "Ordered List (Alpha lower)" );
    comboStyle.insertItem( "Ordered List (Alpha upper)" );
    connect( comboStyle, SIGNAL(" activated( int )"),
	     this, SLOT(" textStyle( int )") );

    comboFont = new TQComboBox( true, tb );
    TQFontDatabase db = new TQFontDatabase();
    comboFont.insertStringList( (String[]) db.families().toArray(new String[0]) );
    connect( comboFont, SIGNAL(" activated( String  )"),
	     this, SLOT(" textFamily( String  )") );
    comboFont.lineEdit().setText( TQApplication.font().family() );

    comboSize = new TQComboBox( true, tb );
    int[] sizes = db.standardSizes();
    for (int i = 0; i < sizes.length; i++ )
	comboSize.insertItem( Integer.toString(sizes[i]) );
    connect( comboSize, SIGNAL(" activated(  String  )"),
	     this, SLOT(" textSize(  String  )") );
    comboSize.lineEdit().setText( Integer.toString( TQApplication.font().pointSize() ) );

    actionTextBold = new TQAction( tr( "Bold" ), new TQIconSet(new TQPixmap( "textbold.xpm" )), tr( "&Bold" ), new TQKeySequence(CTRL + Key_B), this, "textBold" );
    connect( actionTextBold, SIGNAL(" activated()"), this, SLOT(" textBold()") );
    actionTextBold.addTo( tb );
    actionTextBold.addTo( menu );
    actionTextBold.setToggleAction( true );
    actionTextItalic = new TQAction( tr( "Italic" ), new TQIconSet(new TQPixmap( "textitalic.xpm" )), tr( "&Italic" ), new TQKeySequence(CTRL + Key_I), this, "textItalic" );
    connect( actionTextItalic, SIGNAL(" activated()"), this, SLOT(" textItalic()") );
    actionTextItalic.addTo( tb );
    actionTextItalic.addTo( menu );
    actionTextItalic.setToggleAction( true );
    actionTextUnderline = new TQAction( tr( "Underline" ), new TQIconSet(new TQPixmap( "textunder.xpm" )), tr( "&Underline" ), new TQKeySequence(CTRL + Key_U), this, "textUnderline" );
    connect( actionTextUnderline, SIGNAL(" activated()"), this, SLOT(" textUnderline()") );
    actionTextUnderline.addTo( tb );
    actionTextUnderline.addTo( menu );
    actionTextUnderline.setToggleAction( true );
    menu.insertSeparator();

    TQActionGroup grp = new TQActionGroup( this );
    grp.setExclusive( true );
    connect( grp, SIGNAL(" selected( TQAction )"), this, SLOT(" textAlign( TQAction )") );

    actionAlignLeft = new TQAction( tr( "Left" ), new TQIconSet(new TQPixmap( "textleft.xpm" )), tr( "&Left" ), new TQKeySequence(CTRL + Key_L), grp, "textLeft" );
    actionAlignLeft.addTo( tb );
    actionAlignLeft.addTo( menu );
    actionAlignLeft.setToggleAction( true );
    actionAlignCenter = new TQAction( tr( "Center" ), new TQIconSet(new TQPixmap( "textcenter.xpm" )), tr( "C&enter" ), new TQKeySequence(CTRL + Key_E), grp, "textCenter" );
    actionAlignCenter.addTo( tb );
    actionAlignCenter.addTo( menu );
    actionAlignCenter.setToggleAction( true );
    actionAlignRight = new TQAction( tr( "Right" ), new TQIconSet(new TQPixmap( "textright.xpm" )), tr( "&Right" ), new TQKeySequence(CTRL + Key_R), grp, "textRight" );
    actionAlignRight.addTo( tb );
    actionAlignRight.addTo( menu );
    actionAlignRight.setToggleAction( true );
    actionAlignJustify = new TQAction( tr( "Justify" ), new TQIconSet(new TQPixmap( "textjustify.xpm" )), tr( "&Justify" ), new TQKeySequence(CTRL + Key_J), grp, "textjustify" );
    actionAlignJustify.addTo( tb );
    actionAlignJustify.addTo( menu );
    actionAlignJustify.setToggleAction( true );

    menu.insertSeparator();

    TQPixmap pix = new TQPixmap( 16, 16 );
    pix.fill( black() );
    actionTextColor = new TQAction( tr( "Color" ), new TQIconSet(pix), tr( "&Color..." ),  new TQKeySequence(0), this, "textColor" );
    connect( actionTextColor, SIGNAL(" activated()"), this, SLOT(" textColor()") );
    actionTextColor.addTo( tb );
    actionTextColor.addTo( menu );
}

void load(  String f )
{
    if ( !TQFile.exists( f ) )
	return;
    TQTextEdit edit = new TQTextEdit( tabWidget );
    doConnections( edit );
    tabWidget.addTab( edit, new TQFileInfo( f ).fileName() );
    TQFile file = new TQFile( f );
    if ( !file.open( TQIODevice.IO_ReadOnly ) )
	return;
    TQTextStream ts = new TQTextStream( file );
    edit.setText( ts.read() );
    tabWidget.showPage( edit );
    edit.viewport().setFocus();
    filenames.put( edit, f );
}

TQTextEdit currentEditor()
{
    if ( tabWidget.currentPage() != null &&
	 tabWidget.currentPage().inherits( "TQTextEdit" ) )
	return (TQTextEdit)tabWidget.currentPage();
    return null;
}

void doConnections( TQTextEdit e )
{
    connect( e, SIGNAL(" currentFontChanged( TQFont  )"),
	     this, SLOT(" fontChanged(  TQFont  )") );
    connect( e, SIGNAL(" currentColorChanged(  TQColor  )"),
	     this, SLOT(" colorChanged(  TQColor  )") );
    connect( e, SIGNAL(" currentAlignmentChanged( int )"),
	     this, SLOT(" alignmentChanged( int )") );
}

void fileNew()
{
    TQTextEdit edit = new TQTextEdit( tabWidget );
    edit.setTextFormat( RichText );
    doConnections( edit );
    tabWidget.addTab( edit, tr( "noname" ) );
    tabWidget.showPage( edit );
    edit.viewport().setFocus();
}

void fileOpen()
{
    String fn = TQFileDialog.getOpenFileName( "", tr( "HTML-Files (*.htm *.html);;All Files (*)" ), this );
    if ( !fn.equals("") )
	load( fn );
}

void fileSave()
{
    if ( currentEditor() == null )
	return;
    String fn;
    if ( !filenames.containsKey( currentEditor() ) ) {
	fileSaveAs();
    } else {
	TQFile file = new TQFile( (String) filenames.get( currentEditor() ) );
	if ( !file.open( TQIODevice.IO_WriteOnly ) )
	    return;
	TQTextStream ts = new TQTextStream( file );
	ts.writeRawBytes(currentEditor().text(), currentEditor().text().length());
    }
}

void fileSaveAs()
{
    if ( currentEditor() == null )
	return;
    String fn = TQFileDialog.getSaveFileName( "", tr( "HTML-Files (*.htm *.html);;All Files (*)" ), this );
    if ( !fn.equals("") ) {
	filenames.put( currentEditor(), fn );
	fileSave();
	tabWidget.setTabLabel( currentEditor(), new TQFileInfo( fn ).fileName() );
    }
}

void filePrint()
{
    if ( currentEditor() == null )
	return;
    TQPrinter printer = new TQPrinter();
    printer.setFullPage(true);
    if ( printer.setup( this ) ) {
	TQPainter p = new TQPainter( printer );
	// Check that there is a valid device to print to.
	if ( p.device() == null ) return;
	TQPaintDeviceMetrics metrics = new TQPaintDeviceMetrics( p.device() );
	int dpix = metrics.logicalDpiX();
	int dpiy = metrics.logicalDpiY();
	 int margin = 72; // pt
	TQRect body = new TQRect( margin * dpix / 72, margin * dpiy / 72,
		    metrics.width() - margin * dpix / 72 * 2,
		    metrics.height() - margin * dpiy / 72 * 2 );
	TQFont font = new TQFont( "times", 10 );
	TQSimpleRichText richText = new TQSimpleRichText( currentEditor().text(), font, currentEditor().context(), currentEditor().styleSheet(),
				  currentEditor().mimeSourceFactory(), body.height() );
	richText.setWidth( p, body.width() );
	TQRect view = new TQRect( body.topLeft(), body.bottomRight() );
	int page = 1;
	do {
	    richText.draw( p, body.left(), body.top(), view, colorGroup() );
	    view.moveBy( 0, body.height() );
	    p.translate( 0 , -body.height() );
	    p.setFont( font );
	    p.drawText( view.right() - p.fontMetrics().width( Integer.toString(page) ),
			view.bottom() + p.fontMetrics().ascent() + 5, Integer.toString(page) );
	    if ( view.top()  >= richText.height() )
		break;
	    printer.newPage();
	    page++;
	} while (true);
    }
}

void fileClose()
{
//    delete currentEditor();
    if ( currentEditor() != null )
	currentEditor().viewport().setFocus();				
}

void fileExit()
{
    tqApp().quit();
}

void editUndo()
{
    if ( currentEditor() == null )
	return;
    currentEditor().undo();
}

void editRedo()
{
    if ( currentEditor() == null )
	return;
    currentEditor().redo();
}

void editCut()
{
    if ( currentEditor() == null )
	return;
    currentEditor().cut();
}

void editCopy()
{
    if ( currentEditor() == null )
	return;
    currentEditor().copy();
}

void editPaste()
{
    if ( currentEditor() == null )
	return;
    currentEditor().paste();
}

void textBold()
{
    if ( currentEditor() == null )
	return;
    currentEditor().setBold( actionTextBold.isOn() );
}

void textUnderline()
{
    if ( currentEditor() == null )
	return;
    currentEditor().setUnderline( actionTextUnderline.isOn() );
}

void textItalic()
{
    if ( currentEditor() == null )
	return;
    currentEditor().setItalic( actionTextItalic.isOn() );
}

void textFamily(  String f )
{
    if ( currentEditor() == null )
	return;
    currentEditor().setFamily( f );
    currentEditor().viewport().setFocus();
}

void textSize(  String p )
{
    if ( currentEditor() == null )
	return;
    currentEditor().setPointSize( Integer.parseInt(p) );
    currentEditor().viewport().setFocus();
}

void textStyle( int i )
{
    if ( currentEditor() == null )
	return;
    if ( i == 0 )
	currentEditor().setParagType( TQStyleSheetItem.DisplayBlock, TQStyleSheetItem.ListDisc );
    else if ( i == 1 )
	currentEditor().setParagType( TQStyleSheetItem.DisplayListItem, TQStyleSheetItem.ListDisc );
    else if ( i == 2 )
	currentEditor().setParagType( TQStyleSheetItem.DisplayListItem, TQStyleSheetItem.ListCircle );
    else if ( i == 3 )
	currentEditor().setParagType( TQStyleSheetItem.DisplayListItem, TQStyleSheetItem.ListSquare );
    else if ( i == 4 )
	currentEditor().setParagType( TQStyleSheetItem.DisplayListItem, TQStyleSheetItem.ListDecimal );
    else if ( i == 5 )
	currentEditor().setParagType( TQStyleSheetItem.DisplayListItem, TQStyleSheetItem.ListLowerAlpha );
    else if ( i == 6 )
	currentEditor().setParagType( TQStyleSheetItem.DisplayListItem, TQStyleSheetItem.ListUpperAlpha );
    currentEditor().viewport().setFocus();
}

void textColor()
{
    if ( currentEditor() == null )
	return;
    TQColor col = TQColorDialog.getColor( currentEditor().color(), this );
    if ( !col.isValid() )
	return;
    currentEditor().setColor( col );
    TQPixmap pix = new TQPixmap( 16, 16 );
    pix.fill( black() );
    actionTextColor.setIconSet( new TQIconSet(pix) );
}

void textAlign( TQAction a )
{
    if ( currentEditor() == null )
	return;
    if ( a == actionAlignLeft )
	currentEditor().setAlignment( AlignLeft );
    else if ( a == actionAlignCenter )
	currentEditor().setAlignment( AlignHCenter );
    else if ( a == actionAlignRight )
	currentEditor().setAlignment( AlignRight );
    else if ( a == actionAlignJustify )
	currentEditor().setAlignment( AlignJustify );
}

void fontChanged(  TQFont f )
{
    comboFont.lineEdit().setText( f.family() );
    comboSize.lineEdit().setText( Integer.toString( f.pointSize() ) );
    actionTextBold.setOn( f.bold() );
    actionTextItalic.setOn( f.italic() );
    actionTextUnderline.setOn( f.underline() );
}

void colorChanged(  TQColor c )
{
    TQPixmap pix = new TQPixmap( 16, 16 );
    pix.fill( c );
    actionTextColor.setIconSet( new TQIconSet(pix) );
}

void alignmentChanged( int a )
{
    if ( ( a == AlignAuto ) || ( a & AlignLeft ) != 0)
	actionAlignLeft.setOn( true );
    else if ( ( a & AlignHCenter ) != 0 )
	actionAlignCenter.setOn( true );
    else if ( ( a & AlignRight ) != 0 )
	actionAlignRight.setOn( true );
    else if ( ( a & AlignJustify ) != 0 )
	actionAlignJustify.setOn( true );
}

void editorChanged( TQWidget w )
{
    if ( currentEditor() == null )
	return;
    fontChanged( currentEditor().font() );
    colorChanged( currentEditor().color() );
    alignmentChanged( currentEditor().alignment() );
}
}
