// package com.werpu.simplemail;


/**
 * SimpleMailFrm
 * This is the main window from of the simple mail application
 * @author Werner Punz werpu@gmx.at
 * This class was generated by Qt Designer and then converted to Java and
 * redesigned to fit into the KDE Framework
 */

import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;
import java.util.StringTokenizer;
import java.util.LinkedList;



class SimpleMailFrm extends TDEMainWindow {


    TQGroupBox groupBox1;
    KLineEdit txtServer;
    KLineEdit txtUserName;
    KPasswordEdit txtPassword;
    TQLabel textLabel1;
    TQLabel textLabel2;
    TQLabel textLabel3;
    KLineEdit txtFrom;
    KLineEdit txtTo;
    KLineEdit txtBCC;
    TQLabel textLabel4;
    TQLabel textLabel6;
    TQLabel textLabel5;
    KPushButton btSend;
    KPushButton btCancel;
    TQMultiLineEdit txtMessage;


    TQGridLayout form1Layout;
    TQGridLayout groupBox1Layout;

    TDEApplication parentApp = null;

    public SimpleMailFrm(TDEApplication kApp)

    {
        super( null, null,0);
        parentApp = kApp;


        resize( 582, 486 );
        setCaption( trUtf8( "Simple Mailer" ) );

        TQGroupBox centralBox = new TQGroupBox((TQWidget) this,"");

        form1Layout = new TQGridLayout(centralBox, 1, 1, 11, 6, "form1Layout");

        groupBox1 = new TQGroupBox( centralBox, "groupBox1" );
        groupBox1.setTitle( trUtf8( "Mailserver data" ) );
        groupBox1.setColumnLayout(0, Qt.Vertical );
        groupBox1.layout().setSpacing( 6 );
        groupBox1.layout().setMargin( 11 );
        groupBox1Layout = new TQGridLayout( groupBox1.layout() );
        groupBox1Layout.setAlignment( Qt.AlignTop );

        txtServer = new KLineEdit( groupBox1, "txtServer" );

        groupBox1Layout.addWidget( txtServer, 0, 1 );

        txtUserName = new KLineEdit( groupBox1, "txtUserName" );

        groupBox1Layout.addWidget( txtUserName, 1, 1 );

        txtPassword = new KPasswordEdit( groupBox1, "txtPassword" );

        groupBox1Layout.addWidget( txtPassword, 2, 1 );

        textLabel1 = new TQLabel( groupBox1, "textLabel1" );
        textLabel1.setText( trUtf8( "Server" ) );

        groupBox1Layout.addWidget( textLabel1, 0, 0 );

        textLabel2 = new TQLabel( groupBox1, "textLabel2" );
        textLabel2.setText( trUtf8( "Username" ) );

        groupBox1Layout.addWidget( textLabel2, 1, 0 );

        textLabel3 = new TQLabel( groupBox1, "textLabel3" );
        textLabel3.setText( trUtf8( "Password" ) );

        groupBox1Layout.addWidget( textLabel3, 2, 0 );

        txtFrom = new KLineEdit( groupBox1, "txtFrom" );

        groupBox1Layout.addWidget( txtFrom, 0, 3 );

        txtTo = new KLineEdit( groupBox1, "txtTo" );

        groupBox1Layout.addWidget( txtTo, 1, 3 );

        txtBCC = new KLineEdit( groupBox1, "txtBCC" );

        groupBox1Layout.addWidget( txtBCC, 2, 3 );

        textLabel4 = new TQLabel( groupBox1, "textLabel4" );
        textLabel4.setText( trUtf8( "From" ) );

        groupBox1Layout.addWidget( textLabel4, 0, 2 );

        textLabel6 = new TQLabel( groupBox1, "textLabel6" );
        textLabel6.setText( trUtf8( "BCC" ) );

        groupBox1Layout.addWidget( textLabel6, 2, 2 );

        textLabel5 = new TQLabel( groupBox1, "textLabel5" );
        textLabel5.setText( trUtf8( "To" ) );

        groupBox1Layout.addWidget( textLabel5, 1, 2 );

        form1Layout.addMultiCellWidget( groupBox1, 0, 0, 0, 1 );

        btSend = new KPushButton( centralBox, "btSend" );
        btSend.setText( trUtf8( "Send" ) );

        form1Layout.addWidget( btSend, 2, 0 );

        btCancel = new KPushButton( centralBox, "btCancel" );
        btCancel.setText( trUtf8( "Cancel" ) );

        form1Layout.addWidget( btCancel, 2, 1 );

        txtMessage = new TQMultiLineEdit(centralBox, "txtMessage" );

        form1Layout.addMultiCellWidget( txtMessage, 1, 1, 0, 1 );

        setCentralWidget(centralBox);
        // tab order
        setTabOrder( txtServer, txtUserName );
        setTabOrder( txtUserName, txtPassword );
        setTabOrder( txtPassword, txtFrom );
        setTabOrder( txtFrom, txtTo );
        setTabOrder( txtTo, txtBCC );
        setTabOrder( txtBCC, txtMessage );
        setTabOrder( txtMessage, btSend );
        setTabOrder( btSend, btCancel );

        setEventHandlers();
    }

    //----------------------------------------------------------
    // Getter Methods to access the data outside of the
    // current class
    //----------------------------------------------------------

    public String getServer() {
        return txtServer.text();
    }

    public String getUserName() {
        return txtUserName.text();
    }

    public String getPassword() {
        return txtPassword.text();
    }

    public String getFrom() {
        return txtFrom.text();
    }

    public String getTo() {
        return txtTo.text();
    }

    public String getBCC() {
        return txtBCC.text();
    }

    public String getMessage() {
        return txtMessage.text();
    }

    void setEventHandlers() {
        connect( btCancel, SIGNAL("clicked()"), parentApp, SLOT("quit()"));
        connect( btSend,SIGNAL("clicked()"),this,SLOT("sendMail()"));
    }


    //--------------------------------------------
    // Slots
    //-------------------------------------------
    public void sendMail() {
        String server = getServer();
        String userName = getUserName();
        String password = getPassword();
        String from = getFrom();
        String to = getTo();
        String message = getMessage();
        LinkedList bccs = getBCCs();

        try {
            MailHelper mailer = new MailHelper();
            mailer.setMessage(message);
            mailer.setSubject("Simple Mail");
            mailer.setSender(from);
            mailer.setRecipient(to);
            mailer.addCCAddress(bccs.iterator());
            mailer.setServer(server);
            mailer.setUsername(userName);
            mailer.setPassword(password);
            mailer.send();
        }
        catch (Exception ex) {
            KMessageBox.error(this , ex.getMessage());
            return;
        }
        KMessageBox.information(this,"Mail was successfully sent!");
    }

    //-------------------------------------
    //Helpers
    //-------------------------------------

    /**
     * Split the BCCs into single entries if nedded
     */
    LinkedList getBCCs() {
        LinkedList retVal = new LinkedList();

        String bcc = getBCC();
        StringTokenizer splitter = new StringTokenizer(bcc,",;");

        while(splitter.hasMoreTokens())
            retVal.add(splitter.nextToken());

        return retVal;
    }
}

