/*
    cryptoconfigmodule.h

    This file is part of libkleopatra
    Copyright (c) 2004,2005 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License,
    version 2, as published by the Free Software Foundation.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef CRYPTOCONFIGMODULE_H
#define CRYPTOCONFIGMODULE_H

#include <kjanuswidget.h>

#include <tqvaluelist.h>

namespace Kleo {

  class CryptoConfig;
  class CryptoConfigComponentGUI;

  /**
   * Crypto Config Module widget, dynamically generated from CryptoConfig
   * It's a simple TQWidget so that it can be embedded into a dialog or into a TDECModule.
   */
  class CryptoConfigModule : public KJanusWidget {
    TQ_OBJECT
  
  public:
    CryptoConfigModule( Kleo::CryptoConfig* config, TQWidget * parent=0, const char * name=0 );

    bool hasError() const;

    void save();
    void reset(); // i.e. reload current settings, discarding user input
    void defaults();
    void cancel();

  signals:
    void changed();

  private:
    Kleo::CryptoConfig* mConfig;
    TQValueList<CryptoConfigComponentGUI *> mComponentGUIs;
  };

}

#endif
