/***************************************************************************
               tdefilereplace.cpp  -  TDEFileReplace shell implementation
                             -------------------
    begin                : Thu Sep 16 14:14:09 2004
    copyright            : (C) 2004 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//kde includes
#include <kedittoolbar.h>
#include <klibloader.h>
#include <tdelocale.h>
#include <kkeydialog.h>
#include <tdemessagebox.h>

//app includes
#include "tdefilereplace.h"

TDEFileReplace::TDEFileReplace()
 : KParts::MainWindow(0L, "TDEFileReplace")
{
    KLibFactory *factory = KLibLoader::self()->factory("libtdefilereplacepart");
    if (factory)
    {
        m_part = static_cast<KParts::ReadOnlyPart *>(factory->create(this,
                "tdefilereplace_part", "KParts::ReadOnlyPart" ));

        if (m_part)
        {
            setCentralWidget(m_part->widget());
            KStdAction::quit(this, TQ_SLOT(close()), actionCollection());
            KStdAction::keyBindings(this, TQ_SLOT(slotConfigureKeys()), actionCollection());
            KStdAction::configureToolbars(this, TQ_SLOT(slotConfigureToolbars()), actionCollection());
            setStandardToolBarMenuEnabled(true);
            createGUI(m_part);
            removeDuplicatedActions();
        }
    }
    else
    {
        KMessageBox::error(this, i18n("Could not find the TDEFileReplace part."));
        close();
        return;
    }
}


TDEFileReplace::~TDEFileReplace()
{
}

void TDEFileReplace::openURL(const KURL &url)
{
  m_part->openURL(url);
}

void TDEFileReplace::slotConfigureKeys()
{
    KKeyDialog dlg( false, this );
    TQPtrList<KXMLGUIClient> clients = guiFactory()->clients();
    for( TQPtrListIterator<KXMLGUIClient> it( clients );
            it.current(); ++it )
    {
        dlg.insert( (*it)->actionCollection() );
    }
    dlg.configure();
}

void TDEFileReplace::slotConfigureToolbars()
{
    saveMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
    KEditToolbar dlg(factory());
    connect(&dlg, TQ_SIGNAL(newToolbarConfig()),
            this, TQ_SLOT(applyNewToolbarConfig()));
    dlg.exec();
}

void TDEFileReplace::applyNewToolbarConfig()
{
    applyMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
}


void TDEFileReplace::removeDuplicatedActions()
{
    TDEActionCollection* part_action_collection = m_part->actionCollection();
    TDEAction* part_about_action = part_action_collection->action("help_about_tdefilereplace");
    TDEAction* part_report_action = part_action_collection->action("report_bug");
    TDEAction* part_help_action= part_action_collection->action("help_tdefilereplace");

    if (!part_about_action || !part_report_action || !part_help_action || !part_action_collection) 
      return;

    TQWidget* container = part_about_action->container(0);
    part_about_action->unplug(container);
    part_report_action->unplug(container);
    part_help_action->unplug(container);
    part_action_collection->remove(part_about_action);
    part_action_collection->remove(part_report_action);
    part_action_collection->remove(part_help_action);
}

#include "tdefilereplace.moc"
