/*
 * This file is part of the Polkit-tqt project
 * Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>
 * Copyright (C) 2010 Dario Freddi <drf@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <polkit/polkit.h>

#include "polkit-tqt-actiondescription.h"

#include <tqshared.h>
#include <tqstring.h>


namespace PolkitTQt
{

//--------------------------------------
// ActionDescription::Data
//--------------------------------------

class ActionDescription::Data : public TQShared
{
  public:
    Data()
    {
    }

    Data(const Data &other) : actionId(other.actionId), description(other.description),
            message(other.message), vendorName(other.vendorName), vendorUrl(other.vendorUrl),
            iconName(other.iconName), implicitAny(other.implicitAny),
            implicitInactive(other.implicitInactive), implicitActive(other.implicitActive)
    {
    }

    ~Data()
    {
    }

    TQString actionId;
    TQString description;
    TQString message;
    TQString vendorName;
    TQString vendorUrl;
    TQString iconName;

    ImplicitAuthorization implicitAny;
    ImplicitAuthorization implicitInactive;
    ImplicitAuthorization implicitActive;
};

//--------------------------------------
// ActionDescription
//--------------------------------------

ActionDescription::ActionDescription() : d(new Data)
{
}

ActionDescription::ActionDescription(PolkitActionDescription *pkActionDescription) : d(new Data)
{
  d->actionId    = TQString::fromUtf8(polkit_action_description_get_action_id(pkActionDescription));
  d->description = TQString::fromUtf8(polkit_action_description_get_description(pkActionDescription));
  d->message     = TQString::fromUtf8(polkit_action_description_get_message(pkActionDescription));
  d->vendorName  = TQString::fromUtf8(polkit_action_description_get_vendor_name(pkActionDescription));
  d->vendorUrl   = TQString::fromUtf8(polkit_action_description_get_vendor_url(pkActionDescription));
  d->iconName    = TQString::fromUtf8(polkit_action_description_get_icon_name(pkActionDescription));

  d->implicitAny = static_cast<ImplicitAuthorization>(
          polkit_action_description_get_implicit_any(pkActionDescription));
  d->implicitInactive = static_cast<ImplicitAuthorization>(
          polkit_action_description_get_implicit_inactive(pkActionDescription));
  d->implicitActive = static_cast<ImplicitAuthorization>(
          polkit_action_description_get_implicit_active(pkActionDescription));
}

ActionDescription::ActionDescription(const ActionDescription &other) : d(other.d)
{
  d->ref();
}

ActionDescription& ActionDescription::operator=(const ActionDescription &other)
{
  if (d != other.d)
  {
    if (d->deref())
    {
      delete d;
    }
    d = other.d;
    d->ref();
  }
  return *this;
}

ActionDescription::~ActionDescription()
{
  if (d->deref())
  {
    delete d;
  }
}

TQString ActionDescription::actionId() const
{
  return d->actionId;
}

TQString ActionDescription::description() const
{
  return d->description;
}

TQString ActionDescription::message() const
{
  return d->message;
}

TQString ActionDescription::vendorName() const
{
  return d->vendorName;
}

TQString ActionDescription::vendorUrl() const
{
  return d->vendorUrl;
}

TQString ActionDescription::iconName() const
{
  return d->iconName;
}

ActionDescription::ImplicitAuthorization ActionDescription::implicitAny() const
{
  return d->implicitAny;
}

ActionDescription::ImplicitAuthorization ActionDescription::implicitInactive() const
{
  return d->implicitInactive;
}

ActionDescription::ImplicitAuthorization ActionDescription::implicitActive() const
{
  return d->implicitActive;
}

}
